/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.Locale;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.NodeCopier;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.TransformerUtils;

public class CopierDecorator
extends BaseTransformer
implements DecoratedCopier,
DecoratedConverter,
ExplicitTransformer {
    private Copier nestedCopier;
    private Locale defaultLocale;

    public CopierDecorator() {
    }

    public CopierDecorator(Copier copier) {
        this(copier, null);
    }

    public CopierDecorator(Copier copier, Locale defaultLocale) {
        this.setNestedCopier(copier);
        this.setDefaultLocale(defaultLocale);
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws TransformationException {
        this.getNestedCopier().copy(destination, source, locale);
    }

    public Copier getNestedCopier() {
        return this.nestedCopier;
    }

    public void setNestedCopier(Copier copier) {
        this.nestedCopier = copier;
        if (copier instanceof NodeCopier) {
            ((NodeCopier)copier).setNestedTransformer(this.getNestedTransformer());
        }
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public synchronized void setSourceClasses(Class[] sourceClasses) {
        super.setSourceClasses(sourceClasses);
    }

    protected Class[] getSourceClassesImpl() {
        return this.nestedCopier.getSourceClasses();
    }

    public synchronized void setDestinationClasses(Class[] destinationClasses) {
        super.setDestinationClasses(destinationClasses);
    }

    protected Class[] getDestinationClassesImpl() {
        return this.nestedCopier.getDestinationClasses();
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return false;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return false;
    }

    protected void setNestedTransformer(Transformer nestedTransformer) {
        super.setNestedTransformer(nestedTransformer);
        if (this.nestedCopier instanceof NodeCopier) {
            ((NodeCopier)this.nestedCopier).setNestedTransformer(nestedTransformer);
        }
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        return TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType) && TransformerUtils.isTransformable(this.getNestedTransformer(), destinationType, sourceType);
    }

    protected Locale getLocale() {
        Locale locale = this.getDefaultLocale();
        return locale == null ? super.getLocale() : locale;
    }
}

