/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.Locale;
import java.util.Map;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.NodeCopier;
import net.sf.morph.transform.Transformer;
import net.sf.morph.transform.transformers.BaseReflectorTransformer;
import net.sf.morph.util.TransformerUtils;

public abstract class BasePropertyNameCopier
extends BaseReflectorTransformer
implements DecoratedCopier,
DecoratedConverter,
NodeCopier {
    private static final Class[] SOURCE_AND_DESTINATION_TYPES = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = BasePropertyNameCopier.class$("java.lang.Object")) : class$java$lang$Object};
    private boolean errorOnMissingProperty = false;
    private Map propertyTransformers;
    static /* synthetic */ Class class$java$lang$Object;

    public BasePropertyNameCopier() {
    }

    public BasePropertyNameCopier(boolean errorOnMissingProperty) {
        this.errorOnMissingProperty = errorOnMissingProperty;
    }

    public Object createReusableSource(Class destinationClass, Object source) {
        return super.createReusableSource(destinationClass, source);
    }

    public boolean isErrorOnMissingProperty() {
        return this.errorOnMissingProperty;
    }

    public void setErrorOnMissingProperty(boolean isStrict) {
        this.errorOnMissingProperty = isStrict;
    }

    protected Transformer chooseTransformer(String sourceProperty, Object source, String destinationProperty, Object destination, Locale locale, Integer preferredTransformationType) {
        Transformer t;
        Map m = this.getPropertyTransformers();
        if (m != null && (t = (Transformer)m.get(sourceProperty)) != null) {
            NodeCopier nc;
            if (t instanceof NodeCopier && (nc = (NodeCopier)t).getNestedTransformer() == null) {
                nc.setNestedTransformer(this.getNestedTransformer());
            }
            return t;
        }
        return this.getNestedTransformer();
    }

    protected void copyProperty(String sourceProperty, Object source, String destinationProperty, Object destination, Locale locale, Integer preferredTransformationType) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Copying property '" + sourceProperty + "' of " + ObjectUtils.getObjectDescription((Object)source) + " to property '" + destinationProperty + "' of " + ObjectUtils.getObjectDescription((Object)destination)));
        }
        Class destinationType = this.getBeanReflector().getType(destination, destinationProperty);
        Object sourceValue = this.getBeanReflector().get(source, sourceProperty);
        Object destinationValue = null;
        if (this.getBeanReflector().isReadable(destination, destinationProperty)) {
            destinationValue = this.getBeanReflector().get(destination, destinationProperty);
        }
        preferredTransformationType = this.getPreferredTransformationType(source, sourceProperty, sourceValue, destination, destinationProperty, destinationValue, locale, preferredTransformationType);
        Transformer transformer = this.chooseTransformer(sourceProperty, source, destinationProperty, destination, locale, preferredTransformationType);
        Object newDestinationValue = TransformerUtils.transform(transformer, destinationType, destinationValue, sourceValue, locale, preferredTransformationType);
        this.getBeanReflector().set(destination, destinationProperty, newDestinationValue);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Done copying property '" + sourceProperty + "' to property '" + destinationProperty + "'.  sourceValue was " + ObjectUtils.getObjectDescription((Object)sourceValue) + " and destinationValue was " + ObjectUtils.getObjectDescription((Object)destinationValue)));
        }
    }

    protected Integer getPreferredTransformationType(Object source, String sourceProperty, Object sourceValue, Object destination, String destinationProperty, Object destinationValue, Locale locale, Integer preferredTransformationType) {
        return preferredTransformationType;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return false;
    }

    public Transformer getNestedTransformer() {
        return super.getNestedTransformer();
    }

    public void setNestedTransformer(Transformer transformer) {
        super.setNestedTransformer(transformer);
    }

    public Map getPropertyTransformers() {
        return this.propertyTransformers;
    }

    public void setPropertyTransformers(Map propertyTransformers) {
        this.propertyTransformers = propertyTransformers;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    public void setSourceClasses(Class[] sourceClasses) {
        super.setSourceClasses(sourceClasses);
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    public void setDestinationClasses(Class[] destinationClasses) {
        super.setDestinationClasses(destinationClasses);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

