/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextToNumberConverter
extends BaseTransformer
implements DecoratedConverter {
    private static final char RIGHT_PARENTHESES = ')';
    private static final char LEFT_PARENTHESES = '(';
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$morph$transform$converters$TextToNumberConverter == null ? (class$net$sf$morph$transform$converters$TextToNumberConverter = TextToNumberConverter.class$("net.sf.morph.transform.converters.TextToNumberConverter")) : class$net$sf$morph$transform$converters$TextToNumberConverter));
    public static final int WHITESPACE_IGNORE = 0;
    public static final int WHITESPACE_REJECT = 1;
    public static final int CURRENCY_IGNORE = 0;
    public static final int CURRENCY_REJECT = 1;
    public static final int PERCENTAGE_IGNORE = 0;
    public static final int PERCENTAGE_REJECT = 1;
    public static final int PERCENTAGE_CONVERT_TO_DECIMAL = 2;
    public static final int PARENTHESES_IGNORE = 0;
    public static final int PARENTHESES_REJECT = 1;
    public static final int PARENTHESES_NEGATE = 2;
    private Converter textConverter;
    private Converter numberConverter;
    private int whitespaceHandling = 0;
    private int currencyHandling = 0;
    private int percentageHandling = 2;
    private int parenthesesHandling = 2;
    static /* synthetic */ Class class$net$sf$morph$transform$converters$TextToNumberConverter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        String string = (String)this.getTextConverter().convert(class$java$lang$String == null ? (class$java$lang$String = TextToNumberConverter.class$("java.lang.String")) : class$java$lang$String, source, locale);
        StringBuffer charactersToParse = this.removeIgnoredCharacters(string, locale);
        boolean negate = this.handleParenthesesNegation(charactersToParse, locale);
        negate = negate || this.handleNegativeSignNegation(charactersToParse, locale);
        NumberFormat format = null;
        ParsePosition position = null;
        Number number = null;
        Object returnVal = null;
        String stringToParse = charactersToParse.toString();
        if (this.getPercentageHandling() == 2) {
            format = NumberFormat.getPercentInstance(locale);
            position = new ParsePosition(0);
            number = format.parse(stringToParse, position);
            if (this.isParseSuccessful(stringToParse, position)) {
                returnVal = this.negateIfNecessary(number, negate, locale);
                returnVal = this.getNumberConverter().convert(destinationClass, returnVal, locale);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully parsed '" + source + "' as a percentage with value " + returnVal));
                }
                return returnVal;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not perform conversion of '" + source + "' by treating the source as a percentage"));
            }
        }
        format = NumberFormat.getInstance(locale);
        position = new ParsePosition(0);
        number = format.parse(stringToParse, position);
        if (this.isParseSuccessful(stringToParse, position)) {
            returnVal = this.negateIfNecessary(number, negate, locale);
            returnVal = this.getNumberConverter().convert(destinationClass, returnVal, locale);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully parsed '" + source + "' as a number or currency value of " + returnVal));
            }
            return returnVal;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not perform conversion of '" + source + "' by treating the source as a regular number or currency value"));
        }
        throw new TransformationException(destinationClass, source);
    }

    private Object negateIfNecessary(Number returnVal, boolean negate, Locale locale) {
        if (negate) {
            BigDecimal bd = (BigDecimal)this.getNumberConverter().convert(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TextToNumberConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, returnVal, locale);
            return bd.negate();
        }
        return returnVal;
    }

    private StringBuffer removeIgnoredCharacters(String string, Locale locale) {
        StringBuffer charactersToParse = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            DecimalFormatSymbols symbols;
            char currentChar = string.charAt(i);
            if (this.getWhitespaceHandling() == 0 && Character.isWhitespace(currentChar) || this.getCurrencyHandling() == 0 && Character.getType(currentChar) == 26 || this.getPercentageHandling() == 0 && currentChar == (symbols = new DecimalFormatSymbols(locale)).getPercent() || this.getParenthesesHandling() == 0 && (currentChar == '(' || currentChar == ')')) continue;
            charactersToParse.append(currentChar);
        }
        return charactersToParse;
    }

    private boolean handleParenthesesNegation(StringBuffer charactersToParse, Locale locale) {
        int lastCharIndex = charactersToParse.length() - 1;
        if (this.getParenthesesHandling() == 2 && charactersToParse.charAt(0) == '(' && charactersToParse.charAt(lastCharIndex) == ')') {
            charactersToParse.deleteCharAt(lastCharIndex);
            charactersToParse.deleteCharAt(0);
            return true;
        }
        return false;
    }

    private boolean handleNegativeSignNegation(StringBuffer charactersToParse, Locale locale) {
        if (charactersToParse.charAt(0) == '-') {
            charactersToParse.deleteCharAt(0);
            return true;
        }
        if (charactersToParse.charAt(charactersToParse.length() - 1) == '-') {
            charactersToParse.deleteCharAt(charactersToParse.length() - 1);
            return true;
        }
        return false;
    }

    protected boolean isParseSuccessful(String stringWithoutIgnoredSymbolsStr, ParsePosition position) {
        return position.getIndex() != 0 && position.getIndex() == stringWithoutIgnoredSymbolsStr.length();
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getTextConverter().getSourceClasses();
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return this.getNumberConverter().getDestinationClasses();
    }

    public Converter getNumberConverter() {
        if (this.numberConverter == null) {
            this.setNumberConverter(Defaults.createNumberConverter());
        }
        return this.numberConverter;
    }

    public void setNumberConverter(Converter numberConverter) {
        this.numberConverter = numberConverter;
    }

    public Converter getTextConverter() {
        if (this.textConverter == null) {
            this.setTextConverter(Defaults.createTextConverter());
        }
        return this.textConverter;
    }

    public void setTextConverter(Converter textConverter) {
        this.textConverter = textConverter;
    }

    public int getCurrencyHandling() {
        return this.currencyHandling;
    }

    public void setCurrencyHandling(int currencyHandling) {
        this.currencyHandling = currencyHandling;
    }

    public int getParenthesesHandling() {
        return this.parenthesesHandling;
    }

    public void setParenthesesHandling(int parenthesesHandling) {
        this.parenthesesHandling = parenthesesHandling;
    }

    public int getPercentageHandling() {
        return this.percentageHandling;
    }

    public void setPercentageHandling(int percentageHandling) {
        this.percentageHandling = percentageHandling;
    }

    public int getWhitespaceHandling() {
        return this.whitespaceHandling;
    }

    public void setWhitespaceHandling(int whitespaceHandling) {
        this.whitespaceHandling = whitespaceHandling;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

