/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.morph.Defaults;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.StringUtils;

public class TextToClassConverter
extends BaseTransformer
implements Converter,
DecoratedConverter {
    public static final String ARRAY_INDICATOR = "[]";
    private static final HashMap CACHE_MAP = new HashMap();
    private static final Class[] DESTINATION_TYPES = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = TextToClassConverter.class$("java.lang.Class")) : class$java$lang$Class};
    private static final Converter DEFAULT_TEXT_CONVERTER = Defaults.createTextConverter();
    private Converter textConverter;
    private boolean useCache = true;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        Class<?> result;
        Object lock;
        String string = StringUtils.removeWhitespace((String)this.getTextConverter().convert(class$java$lang$String == null ? (class$java$lang$String = TextToClassConverter.class$("java.lang.String")) : class$java$lang$String, source, locale));
        Map cache = this.useCache ? this.getCache() : null;
        Object object = lock = this.useCache ? cache : string;
        synchronized (object) {
            Class<?> clazz = result = this.useCache ? (Class<?>)cache.get(string) : null;
            if (result == null) {
                int arrayAt = string.indexOf(ARRAY_INDICATOR);
                Class<?> c = Class.forName(arrayAt < 0 ? string : string.substring(0, arrayAt));
                Class<?> clazz2 = result = arrayAt < 0 ? c : Array.newInstance(c, new int[StringUtils.numOccurrences(string, ARRAY_INDICATOR)]).getClass();
                if (this.useCache) {
                    cache.put(string, result);
                }
            }
        }
        return result;
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return DESTINATION_TYPES;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getTextConverter().getSourceClasses();
    }

    public Converter getTextConverter() {
        if (this.textConverter == null) {
            this.setTextConverter(DEFAULT_TEXT_CONVERTER);
        }
        return this.textConverter;
    }

    public void setTextConverter(Converter textConverter) {
        this.textConverter = textConverter;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getCache() {
        HashMap result;
        HashMap hashMap = CACHE_MAP;
        synchronized (hashMap) {
            Converter cnv = this.getTextConverter();
            result = (HashMap)CACHE_MAP.get(cnv);
            if (result == null) {
                result = new HashMap();
                CACHE_MAP.put(cnv, result);
            }
        }
        return result;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

