/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Locale;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.ContainerUtils;

public class TextToBooleanConverter
extends BaseTransformer
implements DecoratedConverter {
    private Converter textConverter;
    private static final Class[] DESTINATION_TYPES = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = TextToBooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE};
    public static final String[] DEFAULT_TRUE_TEXT = new String[]{"true", "t", "yes", "y"};
    public static final String[] DEFAULT_FALSE_TEXT = new String[]{"false", "f", "no", "n"};
    private String[] trueText;
    private String[] falseText;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        String str = (String)this.getTextConverter().convert(class$java$lang$String == null ? (class$java$lang$String = TextToBooleanConverter.class$("java.lang.String")) : class$java$lang$String, source, locale);
        if (str != null) {
            str = str.toLowerCase();
        }
        if (ContainerUtils.contains(this.getTrueText(), (Object)str)) {
            return Boolean.TRUE;
        }
        if (ContainerUtils.contains(this.getFalseText(), (Object)str)) {
            return Boolean.FALSE;
        }
        if (ObjectUtils.isEmpty((Object)str) && !destinationClass.isPrimitive()) {
            return null;
        }
        throw new TransformationException(destinationClass, source);
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getTextConverter().getSourceClasses();
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return DESTINATION_TYPES;
    }

    public String[] getFalseText() {
        if (ObjectUtils.isEmpty((Object)this.falseText)) {
            this.setFalseText(DEFAULT_FALSE_TEXT);
        }
        return this.falseText;
    }

    public void setFalseText(String[] falseStrings) {
        falseStrings = this.changeToLowerCase(falseStrings);
        this.falseText = falseStrings;
    }

    public String[] getTrueText() {
        if (ObjectUtils.isEmpty((Object)this.trueText)) {
            this.setTrueText(DEFAULT_TRUE_TEXT);
        }
        return this.trueText;
    }

    public void setTrueText(String[] trueStrings) {
        trueStrings = this.changeToLowerCase(trueStrings);
        this.trueText = trueStrings;
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return false;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    private String[] changeToLowerCase(String[] array) {
        if (array == null) {
            return null;
        }
        String[] lowerCase = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            lowerCase[i] = array[i].toLowerCase();
        }
        return lowerCase;
    }

    public Converter getTextConverter() {
        if (this.textConverter == null) {
            this.setTextConverter(Defaults.createTextConverter());
        }
        return this.textConverter;
    }

    public void setTextConverter(Converter textConverter) {
        this.textConverter = textConverter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

