/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.TransformerUtils;

public class TextConverter
extends BaseTransformer
implements DecoratedConverter,
ExplicitTransformer,
ImpreciseTransformer {
    private static final Class CHAR_SEQUENCE = ClassUtils.isJdk14OrHigherPresent() ? ClassUtils.convertToClass("java.lang.CharSequence") : null;
    private static final HashMap CONSTRUCTOR_CACHE = new HashMap();
    private static final Class[] SOURCE_AND_DESTINATION_TYPES;
    private boolean allowStringAsChar = true;
    private boolean emptyNull;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Character;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        String string;
        Class sourceClass = ClassUtils.getClass(source);
        if (destinationClass == null && ClassUtils.inheritanceContains(this.getSourceClasses(), sourceClass)) {
            return null;
        }
        if (TextConverter.isChar(destinationClass) && TextConverter.isChar(sourceClass)) {
            return source;
        }
        String string2 = source == null ? "" : (source instanceof byte[] ? new String((byte[])source) : (string = source instanceof char[] ? new String((char[])source) : source.toString()));
        if (TextConverter.isChar(destinationClass)) {
            if (!this.isAllowStringAsChar()) {
                throw new TransformationException(destinationClass, source);
            }
            if ("".equals(string)) {
                if (destinationClass == Character.TYPE) {
                    throw new TransformationException(destinationClass, source);
                }
                return null;
            }
            return new Character(string.charAt(0));
        }
        if (destinationClass == (class$java$lang$String == null ? (class$java$lang$String = TextConverter.class$("java.lang.String")) : class$java$lang$String) || destinationClass == CHAR_SEQUENCE && CHAR_SEQUENCE != null) {
            return string;
        }
        if (destinationClass == (array$B == null ? (array$B = TextConverter.class$("[B")) : array$B)) {
            return string.getBytes();
        }
        if (destinationClass == (array$C == null ? (array$C = TextConverter.class$("[C")) : array$C)) {
            return string.toCharArray();
        }
        if (ClassUtils.inheritanceContains(this.getDestinationClasses(), destinationClass) && TextConverter.canCreate(destinationClass)) {
            try {
                return TextConverter.getConstructor(destinationClass).newInstance(string);
            }
            catch (Exception e) {
                throw new TransformationException(destinationClass, source, (Throwable)e);
            }
        }
        throw new TransformationException(destinationClass, source);
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        if (!TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType)) {
            return false;
        }
        if (destinationType == null) {
            return true;
        }
        if (sourceType == null) {
            return !destinationType.isPrimitive();
        }
        if (TextConverter.isChar(destinationType)) {
            return TextConverter.isChar(sourceType) || this.isAllowStringAsChar();
        }
        if (TextConverter.isCharSequence(destinationType)) {
            return TextConverter.canCreate(destinationType);
        }
        return ClassUtils.inheritanceContains(this.getDestinationClasses(), destinationType);
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        if (super.isImpreciseTransformationImpl(destinationClass, sourceClass)) {
            return true;
        }
        return TextConverter.isChar(destinationClass) && !TextConverter.isChar(sourceClass);
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return !this.isEmptyNull();
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    public boolean isEmptyNull() {
        return this.emptyNull;
    }

    public void setEmptyNull(boolean emptyNull) {
        this.emptyNull = emptyNull;
    }

    public boolean isAllowStringAsChar() {
        return this.allowStringAsChar;
    }

    public void setAllowStringAsChar(boolean allowStringAsChar) {
        this.allowStringAsChar = allowStringAsChar;
    }

    private static boolean isChar(Class c) {
        return c == Character.TYPE || c == (class$java$lang$Character == null ? (class$java$lang$Character = TextConverter.class$("java.lang.Character")) : class$java$lang$Character);
    }

    private static boolean isCharSequence(Class c) {
        return CHAR_SEQUENCE != null && CHAR_SEQUENCE.isAssignableFrom(c);
    }

    private static synchronized boolean canCreate(Class c) {
        if (CONSTRUCTOR_CACHE.containsKey(c)) {
            return true;
        }
        Constructor<?>[] cs = c.getConstructors();
        for (int i = 0; i < cs.length; ++i) {
            Class<?>[] p = cs[i].getParameterTypes();
            if (p.length != 1 || !p[0].isAssignableFrom(class$java$lang$String == null ? TextConverter.class$("java.lang.String") : class$java$lang$String)) continue;
            CONSTRUCTOR_CACHE.put(c, cs[i]);
            return true;
        }
        return false;
    }

    private static Constructor getConstructor(Class c) {
        return (Constructor)CONSTRUCTOR_CACHE.get(c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Set s = ContainerUtils.createOrderedSet();
        s.add(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = TextConverter.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        s.add(class$java$lang$String == null ? (class$java$lang$String = TextConverter.class$("java.lang.String")) : class$java$lang$String);
        s.add(CHAR_SEQUENCE);
        s.add(array$B == null ? (array$B = TextConverter.class$("[B")) : array$B);
        s.add(array$C == null ? (array$C = TextConverter.class$("[C")) : array$C);
        s.add(class$java$lang$Character == null ? (class$java$lang$Character = TextConverter.class$("java.lang.Character")) : class$java$lang$Character);
        s.add(Character.TYPE);
        s.add(null);
        SOURCE_AND_DESTINATION_TYPES = s.toArray(new Class[s.size()]);
    }
}

