/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.converters.BaseToPrettyTextConverter;
import net.sf.morph.transform.converters.BeanToPrettyTextConverter;
import net.sf.morph.transform.converters.ContainerToPrettyTextConverter;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.MutableInteger;
import net.sf.morph.util.TransformerUtils;

public class ObjectToPrettyTextConverter
extends BaseToPrettyTextConverter {
    public static final Class[] DEFAULT_TYPES_USING_TO_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectToPrettyTextConverter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = ObjectToPrettyTextConverter.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectToPrettyTextConverter.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Short == null ? (class$java$lang$Short = ObjectToPrettyTextConverter.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Character == null ? (class$java$lang$Character = ObjectToPrettyTextConverter.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Byte == null ? (class$java$lang$Byte = ObjectToPrettyTextConverter.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Double == null ? (class$java$lang$Double = ObjectToPrettyTextConverter.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = ObjectToPrettyTextConverter.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectToPrettyTextConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, Long.TYPE, Integer.TYPE, Short.TYPE, Character.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE, Boolean.TYPE, class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = ObjectToPrettyTextConverter.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer};
    public static final int DEFAULT_LEVELS = 1;
    private int levels = 1;
    private Converter containerToPrettyTextConverter;
    private Converter beanToPrettyTextConverter;
    private static ThreadLocal currentLevelThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new MutableInteger(-1);
        }
    };
    private Set typesUsingToString;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public ObjectToPrettyTextConverter() {
        this.setTypesUsingToString(DEFAULT_TYPES_USING_TO_STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        MutableInteger currentLevel = (MutableInteger)currentLevelThreadLocal.get();
        ++currentLevel.value;
        try {
            if (currentLevel.value < this.levels) {
                if (source == null) {
                    String string = "null";
                    return string;
                }
                if (this.getTypesUsingToStringInternal().contains(source.getClass())) {
                    String string = source.toString();
                    return string;
                }
                if (TransformerUtils.isTransformable(this.getContainerToPrettyTextConverter(), destinationClass, ClassUtils.getClass(source))) {
                    Object object = this.getContainerToPrettyTextConverter().convert(destinationClass, source, locale);
                    return object;
                }
                if (TransformerUtils.isTransformable(this.getBeanToPrettyTextConverter(), destinationClass, ClassUtils.getClass(source))) {
                    Object object = this.getBeanToPrettyTextConverter().convert(destinationClass, source, locale);
                    return object;
                }
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Error occurred while attempting to create a formatted text representation of source " + source), (Throwable)e);
            }
        }
        finally {
            --currentLevel.value;
        }
        return this.getToTextConverter().convert(destinationClass, source, locale);
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        Set candidates = ContainerUtils.createOrderedSet();
        candidates.addAll(Arrays.asList(this.getContainerToPrettyTextConverter().getSourceClasses()));
        candidates.addAll(Arrays.asList(this.getBeanToPrettyTextConverter().getSourceClasses()));
        candidates.addAll(Arrays.asList(this.getToTextConverter().getSourceClasses()));
        return candidates.toArray(new Class[candidates.size()]);
    }

    public int getLevels() {
        return this.levels;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public Converter getBeanToPrettyTextConverter() {
        if (this.beanToPrettyTextConverter == null) {
            BeanToPrettyTextConverter converter = new BeanToPrettyTextConverter();
            converter.setToTextConverter(this);
            this.setBeanToPrettyTextConverter(converter);
        }
        return this.beanToPrettyTextConverter;
    }

    public void setBeanToPrettyTextConverter(Converter beanToTextConverter) {
        this.beanToPrettyTextConverter = beanToTextConverter;
    }

    public Converter getContainerToPrettyTextConverter() {
        if (this.containerToPrettyTextConverter == null) {
            ContainerToPrettyTextConverter converter = new ContainerToPrettyTextConverter();
            converter.setToTextConverter(this);
            this.setContainerToPrettyTextConverter(converter);
        }
        return this.containerToPrettyTextConverter;
    }

    public void setContainerToPrettyTextConverter(Converter containerToTextConverter) {
        this.containerToPrettyTextConverter = containerToTextConverter;
    }

    protected Set getTypesUsingToStringInternal() {
        if (this.typesUsingToString == null) {
            this.getTypesUsingToString();
        }
        return this.typesUsingToString;
    }

    public Class[] getTypesUsingToString() {
        if (this.typesUsingToString == null) {
            this.setTypesUsingToString(DEFAULT_TYPES_USING_TO_STRING);
        }
        return this.typesUsingToString.toArray(new Class[this.typesUsingToString.size()]);
    }

    public void setTypesUsingToString(Class[] typesUsingToString) {
        Set s = ContainerUtils.createOrderedSet();
        s.addAll(Arrays.asList(typesUsingToString));
        this.typesUsingToString = s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

