/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.math.BigDecimal;
import java.util.Locale;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.support.NumberRounder;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.NumberUtils;

public class NumberConverter
extends BaseTransformer
implements DecoratedConverter,
ImpreciseTransformer {
    private static final Class[] SOURCE_AND_DESTINATION_TYPES = new Class[]{class$java$lang$Number == null ? (class$java$lang$Number = NumberConverter.class$("java.lang.Number")) : class$java$lang$Number, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, null};
    public static final String DEFAULT_ROUNDING_METHOD = "ROUND_HALF_UP";
    private String roundingMethod;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public NumberConverter() {
        this.setRoundingMethod(DEFAULT_ROUNDING_METHOD);
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return SOURCE_AND_DESTINATION_TYPES;
    }

    protected void checkNotOutOfBounds(Class destinationClass, Number number) throws Exception {
        if (NumberUtils.isTooBigForType(number, destinationClass)) {
            throw new TransformationException(destinationClass, number, null, number + " is too large to be contained in a " + destinationClass.getName());
        }
        if (NumberUtils.isTooSmallForType(number, destinationClass)) {
            throw new TransformationException(destinationClass, number, null, number + " is too small to be contained in a " + destinationClass.getName());
        }
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        return super.isImpreciseTransformationImpl(destinationClass, sourceClass) || NumberUtils.NARROWNESS_COMPARATOR.compare(destinationClass, sourceClass) < 0;
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        String numberStr;
        if (destinationClass == null) {
            return null;
        }
        if (destinationClass.isPrimitive() && source == null) {
            throw new TransformationException(destinationClass, source);
        }
        if (destinationClass.isAssignableFrom(ClassUtils.getClass(source))) {
            return source;
        }
        this.checkNotOutOfBounds(destinationClass, (Number)source);
        if (this.isDecimal(destinationClass)) {
            numberStr = source.toString();
        } else {
            BigDecimal bigDecimal = new BigDecimal(source.toString());
            bigDecimal = bigDecimal.setScale(0, NumberRounder.getBigDecimalRoundMode(this.getRoundingMethod()));
            numberStr = bigDecimal.toString();
        }
        return NumberUtils.getNumber(destinationClass, numberStr);
    }

    protected boolean isDecimal(Class numberType) {
        return numberType == Double.TYPE || numberType == (class$java$lang$Double == null ? (class$java$lang$Double = NumberConverter.class$("java.lang.Double")) : class$java$lang$Double) || numberType == Float.TYPE || numberType == (class$java$lang$Float == null ? (class$java$lang$Float = NumberConverter.class$("java.lang.Float")) : class$java$lang$Float) || (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(numberType);
    }

    public String getRoundingMethod() {
        if (this.roundingMethod == null) {
            this.setRoundingMethod(DEFAULT_ROUNDING_METHOD);
        }
        return this.roundingMethod;
    }

    public void setRoundingMethod(String roundingMethod) {
        this.roundingMethod = roundingMethod;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

