/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Locale;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.TransformerUtils;

public class IdentityConverter
extends BaseTransformer
implements DecoratedConverter,
ExplicitTransformer {
    public static final Class[] DEFAULT_SOURCE_AND_DESTINATION_TYPES = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = IdentityConverter.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, null};
    static /* synthetic */ Class class$java$lang$Object;

    public IdentityConverter() {
    }

    public IdentityConverter(Class[] sourceAndDestinationClasses) {
        this.setSourceClasses(sourceAndDestinationClasses);
        this.setDestinationClasses(sourceAndDestinationClasses);
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        if (TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType)) {
            if (destinationType == sourceType) {
                return true;
            }
            if (destinationType == null) {
                return false;
            }
            if (sourceType == null) {
                return !destinationType.isPrimitive();
            }
            return destinationType.isAssignableFrom(sourceType);
        }
        return false;
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        if (destinationClass.isAssignableFrom(source.getClass())) {
            return source;
        }
        throw new TransformationException(destinationClass, source);
    }

    protected boolean isPerformingLogging() {
        return false;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return DEFAULT_SOURCE_AND_DESTINATION_TYPES;
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return DEFAULT_SOURCE_AND_DESTINATION_TYPES;
    }

    public synchronized void setDestinationClasses(Class[] destinationClasses) {
        super.setDestinationClasses(destinationClasses);
    }

    public synchronized void setSourceClasses(Class[] sourceClasses) {
        super.setSourceClasses(sourceClasses);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

