/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Locale;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.TransformerUtils;

public class ConverterDecorator
extends BaseTransformer
implements DecoratedConverter,
ExplicitTransformer {
    private Converter nestedConverter;
    private Locale defaultLocale;

    public ConverterDecorator() {
    }

    public ConverterDecorator(Converter converter) {
        this(converter, null);
    }

    public ConverterDecorator(Converter converter, Locale defaultLocale) {
        this.setNestedConverter(converter);
        this.setDefaultLocale(defaultLocale);
    }

    public Converter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(Converter converter) {
        this.nestedConverter = converter;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        return this.getNestedConverter().convert(destinationClass, source, locale);
    }

    public synchronized void setSourceClasses(Class[] sourceClasses) {
        super.setSourceClasses(sourceClasses);
    }

    protected Class[] getSourceClassesImpl() {
        return this.getNestedConverter().getSourceClasses();
    }

    public synchronized void setDestinationClasses(Class[] destinationClasses) {
        super.setDestinationClasses(destinationClasses);
    }

    protected Class[] getDestinationClassesImpl() {
        return this.getNestedConverter().getDestinationClasses();
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return false;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return false;
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        return TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType) && TransformerUtils.isTransformable(this.getNestedTransformer(), destinationType, sourceType);
    }

    protected Locale getLocale() {
        Locale locale = this.getDefaultLocale();
        return locale == null ? super.getLocale() : locale;
    }
}

