/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Locale;
import net.sf.morph.Defaults;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.TransformerUtils;

public class BooleanToTextConverter
extends BaseTransformer
implements DecoratedConverter,
ImpreciseTransformer {
    private static final Class[] SOURCE_TYPES = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanToTextConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE};
    private Converter textConverter;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        String string;
        if (source.equals(Boolean.TRUE)) {
            string = this.getTrueString(locale);
        } else if (source.equals(Boolean.FALSE)) {
            string = this.getFalseString(locale);
        } else {
            throw new TransformationException(destinationClass, source);
        }
        return this.getTextConverter().convert(destinationClass, string, locale);
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_TYPES;
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return this.getTextConverter().getDestinationClasses();
    }

    public String getTrueString(Locale locale) {
        return Boolean.TRUE.toString();
    }

    public String getFalseString(Locale locale) {
        return Boolean.FALSE.toString();
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        return TransformerUtils.isImpreciseTransformation(this.getTextConverter(), destinationClass, class$java$lang$String == null ? (class$java$lang$String = BooleanToTextConverter.class$("java.lang.String")) : class$java$lang$String);
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    public Converter getTextConverter() {
        if (this.textConverter == null) {
            this.setTextConverter(Defaults.createTextConverter());
        }
        return this.textConverter;
    }

    public void setTextConverter(Converter textConverter) {
        this.textConverter = textConverter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

