/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Locale;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.transform.converters.BaseToPrettyTextConverter;

public class BeanToPrettyTextConverter
extends BaseToPrettyTextConverter {
    public static final String DEFAULT_PREFIX = "[";
    public static final String DEFAULT_SUFFIX = "]";
    public static final String DEFAULT_SEPARATOR = ",";
    public static final String DEFAULT_NAME_VALUE_SEPARATOR = "=";
    private String nameValueSeparator = "=";
    private boolean showPropertyNames = true;
    static /* synthetic */ Class class$java$lang$String;

    public BeanToPrettyTextConverter() {
        this.setPrefix(DEFAULT_PREFIX);
        this.setSuffix(DEFAULT_SUFFIX);
        this.setSeparator(DEFAULT_SEPARATOR);
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        BeanReflector beanReflector = this.getBeanReflector();
        StringBuffer buffer = new StringBuffer();
        if (this.getPrefix() != null) {
            buffer.append(this.getPrefix());
        }
        String[] propertyNames = beanReflector.getPropertyNames(source);
        boolean separatorNeeded = false;
        if (!ObjectUtils.isEmpty((Object)propertyNames)) {
            Object value;
            String propertyName = propertyNames[0];
            if (beanReflector.isReadable(source, propertyName)) {
                value = beanReflector.get(source, propertyName);
                this.append(buffer, propertyName, value, locale);
                if (value != null || this.isShowNullValues()) {
                    separatorNeeded = true;
                }
            }
            for (int i = 1; i < propertyNames.length; ++i) {
                propertyName = propertyNames[i];
                if (!beanReflector.isReadable(source, propertyName)) continue;
                value = beanReflector.get(source, propertyName);
                if (value != null || this.isShowNullValues()) {
                    if (separatorNeeded) {
                        buffer.append(this.getSeparator());
                    }
                    separatorNeeded = true;
                }
                this.append(buffer, propertyNames[i], value, locale);
            }
        }
        if (this.getSuffix() != null) {
            buffer.append(this.getSuffix());
        }
        return this.getTextConverter().convert(destinationClass, buffer, locale);
    }

    private void append(StringBuffer buffer, String propertyName, Object value, Locale locale) {
        if (value == null && !this.isShowNullValues()) {
            return;
        }
        if (this.isShowPropertyNames()) {
            buffer.append(propertyName).append(this.getNameValueSeparator());
        }
        buffer.append(this.getToTextConverter().convert(class$java$lang$String == null ? (class$java$lang$String = BeanToPrettyTextConverter.class$("java.lang.String")) : class$java$lang$String, value, locale));
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getBeanReflector().getReflectableClasses();
    }

    public String getNameValueSeparator() {
        return this.nameValueSeparator;
    }

    public void setNameValueSeparator(String nameValueSeparator) {
        this.nameValueSeparator = nameValueSeparator;
    }

    public boolean isShowPropertyNames() {
        return this.showPropertyNames;
    }

    public void setShowPropertyNames(boolean showPropertyNames) {
        this.showPropertyNames = showPropertyNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

