/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.converters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.BidirectionalMap;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;

public class ArbitraryObjectMappingConverter
extends BaseTransformer
implements DecoratedConverter {
    private boolean bidirectional = true;
    private Map mapping;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        BidirectionalMap bidirectionalMap;
        if (this.getMapping().containsKey(source)) {
            return this.getMapping().get(source);
        }
        if (this.isBidirectional() && (bidirectionalMap = (BidirectionalMap)this.mapping).getReverseMap().containsKey(bidirectionalMap)) {
            return bidirectionalMap.getKey(source);
        }
        throw new TransformationException("No mapping was specified for source object " + ObjectUtils.getObjectDescription((Object)source));
    }

    protected Class[] getClasses(Collection forwardMappingKeys, Collection backwardMappingKeys) throws Exception {
        int maxNumClasses = forwardMappingKeys.size();
        if (this.isBidirectional()) {
            maxNumClasses += backwardMappingKeys.size();
        }
        Set classes = ContainerUtils.createOrderedSet();
        this.addContainedClasses(classes, forwardMappingKeys);
        if (this.isBidirectional()) {
            this.addContainedClasses(classes, backwardMappingKeys);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected void addContainedClasses(Set classes, Collection objects) {
        if (objects != null) {
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                classes.add(ClassUtils.getClass(i.next()));
            }
        }
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        if (ObjectUtils.isEmpty((Object)this.mapping)) {
            throw new IllegalStateException("The mapping property of this converter must be set");
        }
        return this.getClasses(this.mapping.keySet(), this.mapping.values());
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        if (ObjectUtils.isEmpty((Object)this.mapping)) {
            throw new IllegalStateException("The mapping property of this converter must be set");
        }
        return this.getClasses(this.mapping.values(), this.mapping.keySet());
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.setInitialized(false);
        this.bidirectional = bidirectional;
    }

    public Map getMapping() {
        return this.mapping;
    }

    public void setMapping(Map mapping) {
        this.setInitialized(false);
        this.mapping = this.isBidirectional() && !(mapping instanceof BidirectionalMap) ? new BidirectionalMap(mapping) : mapping;
    }

    public Map getVisitedSourceToDestinationMap() {
        return this.getMapping();
    }

    public void setVisitedSourceToDestinationMap(Map visitedSourceToDestinationMap) {
        throw new UnsupportedOperationException();
    }
}

