/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.support;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sf.morph.reflect.support.MethodHolder;
import net.sf.morph.util.NumberUtils;

public class ReflectionInfo {
    private Map propertyAccessMethods = new HashMap();
    private String[] propertyNames;

    public ReflectionInfo(Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            String methodName = methods[i].getName();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            if (Modifier.isStatic(methods[i].getModifiers())) continue;
            if (methodName.length() > 3 && methodName.indexOf("set") == 0 && Character.isUpperCase(methodName.charAt(3))) {
                propertyName = Introspector.decapitalize(methodName.substring(3));
                if (parameterTypes.length == 1) {
                    this.registerMutator(propertyName, methods[i]);
                    continue;
                }
                if (parameterTypes.length != 2 || !NumberUtils.isNumber(parameterTypes[0])) continue;
                this.registerIndexedMutator(propertyName, methods[i]);
                continue;
            }
            if (methodName.length() > 3 && methodName.indexOf("get") == 0 && Character.isUpperCase(methodName.charAt(3))) {
                propertyName = Introspector.decapitalize(methodName.substring(3));
                if (parameterTypes.length == 0) {
                    this.registerAccessor(propertyName, methods[i]);
                    continue;
                }
                if (parameterTypes.length != 1 || !NumberUtils.isNumber(parameterTypes[0])) continue;
                this.registerIndexedAccessor(propertyName, methods[i]);
                continue;
            }
            if (methodName.length() <= 2 || !methods[i].getReturnType().equals(Boolean.TYPE) || parameterTypes.length != 0 || methodName.indexOf("is") != 0 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Introspector.decapitalize(methodName.substring(2));
            this.registerAccessor(propertyName, methods[i]);
        }
        this.propertyNames = this.propertyAccessMethods.keySet().toArray(new String[this.propertyAccessMethods.size()]);
    }

    protected MethodHolder createOrRetrieveMethodHolder(String propertyName) {
        MethodHolder holder = (MethodHolder)this.propertyAccessMethods.get(propertyName);
        if (holder == null) {
            holder = new MethodHolder();
            this.propertyAccessMethods.put(propertyName, holder);
        }
        return holder;
    }

    protected void registerAccessor(String propertyName, Method method) {
        this.createOrRetrieveMethodHolder(propertyName).setAccessor(method);
    }

    protected void registerMutator(String propertyName, Method method) {
        this.createOrRetrieveMethodHolder(propertyName).setMutator(method);
    }

    protected void registerIndexedAccessor(String propertyName, Method method) {
        this.createOrRetrieveMethodHolder(propertyName).setIndexedAccessor(method);
    }

    protected void registerIndexedMutator(String propertyName, Method method) {
        this.createOrRetrieveMethodHolder(propertyName).setIndexedMutator(method);
    }

    public MethodHolder getMethodHolder(String propertyName) {
        return (MethodHolder)this.propertyAccessMethods.get(propertyName);
    }

    public void set(Object bean, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.getMethodHolder(propertyName).invokeMutator(bean, value);
    }

    public void set(Object bean, String propertyName, Object index, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.getMethodHolder(propertyName).invokeIndexedMutator(bean, index, value);
    }

    public boolean isWriteable(String propertyName) {
        return this.getMethodHolder(propertyName) != null && (this.getMethodHolder(propertyName).getMutator() != null || this.getMethodHolder(propertyName).getIndexedMutator() != null);
    }

    public boolean isReadable(String propertyName) {
        return this.getMethodHolder(propertyName) != null && (this.getMethodHolder(propertyName).getAccessor() != null || this.getMethodHolder(propertyName).getIndexedAccessor() != null);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object get(Object bean, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getMethodHolder(propertyName).invokeAccessor(bean);
    }

    public Object get(Object bean, String propertyName, Object index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getMethodHolder(propertyName).invokeIndexedAccessor(bean, index);
    }
}

