/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.reflectors.BaseReflector;
import net.sf.morph.util.Assert;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.TransformerUtils;
import net.sf.morph.util.TypeMap;

public class SimpleInstantiatingReflector
extends BaseReflector
implements InstantiatingReflector {
    private Map requestedToInstantiatedTypeMap;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public SimpleInstantiatingReflector() {
    }

    public SimpleInstantiatingReflector(Class instantiatedType) {
        this(instantiatedType, instantiatedType);
    }

    public SimpleInstantiatingReflector(Class requestedType, Class instantiatedType) {
        this.setRequestedType(requestedType);
        this.setInstantiatedType(instantiatedType);
    }

    public SimpleInstantiatingReflector(Map requestedToInstantiatedClassMap) {
        this.requestedToInstantiatedTypeMap = requestedToInstantiatedClassMap;
    }

    protected Class[] getReflectableClassesImpl() throws Exception {
        Set reflectableClasses = this.getRequestedToInstantiatedTypeMap().keySet();
        return reflectableClasses.toArray(new Class[reflectableClasses.size()]);
    }

    protected Object newInstanceImpl(Class requestedType, Object parameters) throws Exception {
        Class typeToInstantiate = TransformerUtils.getMappedDestinationType(this.getRequestedToInstantiatedTypeMap(), requestedType);
        if (typeToInstantiate == null) {
            throw new Exception("Unable to instantiate " + requestedType);
        }
        return super.newInstanceImpl(typeToInstantiate, parameters);
    }

    public final Class getInstantiatedType() {
        if (ObjectUtils.isEmpty((Object)this.getRequestedToInstantiatedTypeMap())) {
            return null;
        }
        if (this.getRequestedToInstantiatedTypeMap().size() == 1) {
            return (Class)this.getRequestedToInstantiatedTypeMap().values().iterator().next();
        }
        throw new IllegalStateException("This reflector has multiple mappings of requested types to instantiated types, so a single instantiated type cannot be returned.  The mappings are " + this.getRequestedToInstantiatedTypeMap());
    }

    public final void setInstantiatedType(Class instantiatedType) {
        Class requestedType;
        if (instantiatedType == null || instantiatedType.isInterface() || Modifier.isAbstract(instantiatedType.getModifiers())) {
            throw new IllegalArgumentException("instantiatedType " + instantiatedType);
        }
        try {
            requestedType = this.getRequestedType();
        }
        catch (IllegalStateException e) {
            requestedType = null;
        }
        this.getRequestedToInstantiatedTypeMap().clear();
        this.getRequestedToInstantiatedTypeMap().put(requestedType, instantiatedType);
    }

    public final Class getRequestedType() {
        if (ObjectUtils.isEmpty((Object)this.getRequestedToInstantiatedTypeMap())) {
            return null;
        }
        if (this.getRequestedToInstantiatedTypeMap().size() == 1) {
            return (Class)this.getRequestedToInstantiatedTypeMap().keySet().iterator().next();
        }
        throw new IllegalStateException("This reflector has multiple mappings of requested types to instantiated types, so a single requested type cannot be returned.  The mappings are " + this.getRequestedToInstantiatedTypeMap());
    }

    public final void setRequestedType(Class requestedType) {
        Class instantiatedType;
        Assert.notNull((Object)requestedType, (String)"requestedType");
        try {
            instantiatedType = this.getInstantiatedType();
        }
        catch (IllegalStateException e) {
            instantiatedType = null;
        }
        this.getRequestedToInstantiatedTypeMap().clear();
        this.getRequestedToInstantiatedTypeMap().put(requestedType, instantiatedType);
    }

    public synchronized Map getRequestedToInstantiatedTypeMap() {
        if (this.requestedToInstantiatedTypeMap == null) {
            TypeMap map = new TypeMap();
            map.put(class$java$util$Calendar == null ? (class$java$util$Calendar = SimpleInstantiatingReflector.class$("java.util.Calendar")) : class$java$util$Calendar, class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = SimpleInstantiatingReflector.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar);
            if (ClassUtils.isJdk14OrHigherPresent()) {
                try {
                    map.put(Class.forName("java.lang.CharSequence"), class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = SimpleInstantiatingReflector.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
                }
                catch (ClassNotFoundException e) {
                    throw new ReflectionException(e);
                }
            }
            this.setRequestedToInstantiatedTypeMap(map);
        }
        return this.requestedToInstantiatedTypeMap;
    }

    public synchronized void setRequestedToInstantiatedTypeMap(Map interfaceToImplementationMap) {
        this.requestedToInstantiatedTypeMap = new TypeMap(interfaceToImplementationMap);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

