/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.sf.composite.SpecializableComposite;
import net.sf.composite.StrictlyTypedComposite;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.CompositeReflector;
import net.sf.morph.reflect.ContainerReflector;
import net.sf.morph.reflect.DecoratedReflector;
import net.sf.morph.reflect.GrowableContainerReflector;
import net.sf.morph.reflect.IndexedContainerReflector;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.MutableIndexedContainerReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.reflect.SizableReflector;
import net.sf.morph.reflect.reflectors.ArrayReflector;
import net.sf.morph.reflect.reflectors.BaseCompositeReflector;
import net.sf.morph.reflect.reflectors.BaseReflector;
import net.sf.morph.reflect.reflectors.CollectionReflector;
import net.sf.morph.reflect.reflectors.ContextReflector;
import net.sf.morph.reflect.reflectors.DynaBeanReflector;
import net.sf.morph.reflect.reflectors.EnumerationReflector;
import net.sf.morph.reflect.reflectors.HttpSessionAttributeReflector;
import net.sf.morph.reflect.reflectors.IteratorReflector;
import net.sf.morph.reflect.reflectors.ListReflector;
import net.sf.morph.reflect.reflectors.MapReflector;
import net.sf.morph.reflect.reflectors.ObjectReflector;
import net.sf.morph.reflect.reflectors.PageContextAttributeReflector;
import net.sf.morph.reflect.reflectors.ResetableIteratorWrapperReflector;
import net.sf.morph.reflect.reflectors.ResultSetReflector;
import net.sf.morph.reflect.reflectors.ServletContextAttributeReflector;
import net.sf.morph.reflect.reflectors.ServletRequestReflector;
import net.sf.morph.reflect.reflectors.SetReflector;
import net.sf.morph.reflect.reflectors.SimpleInstantiatingReflector;
import net.sf.morph.reflect.reflectors.SortedSetReflector;
import net.sf.morph.reflect.reflectors.StringTokenizerReflector;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.ReflectorUtils;

public class SimpleDelegatingReflector
extends BaseCompositeReflector
implements DecoratedReflector,
StrictlyTypedComposite,
SpecializableComposite,
BeanReflector,
ContainerReflector,
GrowableContainerReflector,
IndexedContainerReflector,
InstantiatingReflector,
MutableIndexedContainerReflector,
CompositeReflector,
Cloneable {
    static /* synthetic */ Class class$net$sf$morph$reflect$BeanReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$ContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$GrowableContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$SizableReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$IndexedContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$MutableIndexedContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$reflect$InstantiatingReflector;

    public SimpleDelegatingReflector() {
        this(null, true);
    }

    public SimpleDelegatingReflector(Reflector[] components) {
        this(components, false);
    }

    public SimpleDelegatingReflector(Reflector[] components, boolean appendDefaultComponents) {
        if (appendDefaultComponents) {
            Reflector[] defaultComponents = this.createDefaultComponents();
            if (ObjectUtils.isEmpty((Object)components)) {
                components = defaultComponents;
            } else {
                Reflector[] newComponents = (Reflector[])ClassUtils.createArray((Class)this.getComponentType(), (int)(components.length + defaultComponents.length));
                System.arraycopy(components, 0, newComponents, 0, components.length);
                System.arraycopy(defaultComponents, 0, newComponents, components.length, defaultComponents.length);
                components = newComponents;
            }
        }
        this.setComponents(components);
    }

    protected Reflector[] createDefaultComponents() {
        LinkedList<BaseReflector> componentList = new LinkedList<BaseReflector>();
        componentList.add(new ListReflector());
        componentList.add(new SortedSetReflector());
        componentList.add(new SetReflector());
        componentList.add(new StringTokenizerReflector());
        componentList.add(new ResetableIteratorWrapperReflector());
        componentList.add(new EnumerationReflector());
        componentList.add(new IteratorReflector());
        componentList.add(new ArrayReflector(this));
        componentList.add(new CollectionReflector());
        componentList.add(new ResultSetReflector());
        componentList.add(new ContextReflector());
        componentList.add(new MapReflector());
        if (ClassUtils.isServletApiPresent()) {
            componentList.add(new ServletRequestReflector());
            componentList.add(new HttpSessionAttributeReflector());
            componentList.add(new ServletContextAttributeReflector());
        }
        if (ClassUtils.isJspApiPresent()) {
            componentList.add(new PageContextAttributeReflector());
        }
        if (ClassUtils.isBeanUtilsPresent()) {
            componentList.add(new DynaBeanReflector());
        }
        componentList.add(new SimpleInstantiatingReflector());
        componentList.add(new ObjectReflector());
        return componentList.toArray(new Reflector[componentList.size()]);
    }

    protected void initializeImpl() throws Exception {
        super.initializeImpl();
        this.getComponentValidator().validate((Object)this);
    }

    protected Class[] getReflectableClassesImpl() {
        Set set = ContainerUtils.createOrderedSet();
        Object[] reflectors = this.getComponents();
        for (int i = 0; i < reflectors.length; ++i) {
            Class[] reflectableClasses = ((Reflector)reflectors[i]).getReflectableClasses();
            for (int j = 0; j < reflectableClasses.length; ++j) {
                set.add(reflectableClasses[j]);
            }
        }
        return set.toArray(new Class[set.size()]);
    }

    protected Object getImpl(Object bean, String propertyName) throws Exception {
        return this.getBeanReflector(bean).get(bean, propertyName);
    }

    protected String[] getPropertyNamesImpl(Object bean) throws Exception {
        return this.getBeanReflector(bean).getPropertyNames(bean);
    }

    protected Class getTypeImpl(Object bean, String propertyName) throws Exception {
        return this.getBeanReflector(bean).getType(bean, propertyName);
    }

    protected boolean isReadableImpl(Object bean, String propertyName) throws Exception {
        return this.getBeanReflector(bean).isReadable(bean, propertyName);
    }

    protected boolean isWriteableImpl(Object bean, String propertyName) throws Exception {
        return this.getBeanReflector(bean).isWriteable(bean, propertyName);
    }

    protected void setImpl(Object bean, String propertyName, Object value) throws Exception {
        this.getBeanReflector(bean).set(bean, propertyName, value);
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        return this.getContainerReflector(container).getIterator(container);
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        return this.getContainerReflectorForClass(clazz).getContainedType(clazz);
    }

    protected int getSizeImpl(Object container) throws Exception {
        return this.getSizableReflector(container).getSize(container);
    }

    protected boolean addImpl(Object container, Object value) throws Exception {
        return this.getGrowableContainerReflector(container).add(container, value);
    }

    protected Object getImpl(Object container, int index) throws Exception {
        return this.getIndexedContainerReflector(container).get(container, index);
    }

    protected Object setImpl(Object container, int index, Object propertyValue) throws Exception {
        return this.getMutableIndexedContainerReflector(container).set(container, index, propertyValue);
    }

    protected Object newInstanceImpl(Class clazz, Object parameters) throws Exception {
        InstantiatingReflector reflector = this.getInstantiatingReflectorForClass(clazz);
        return reflector.newInstance(clazz, parameters);
    }

    public boolean isReflectableImpl(Class reflectedType, Class reflectorType) throws ReflectionException {
        return this.safeGetReflector(reflectorType, reflectedType) != null;
    }

    protected Reflector getReflector(Class reflectorType, Class reflectedType) {
        Reflector result = this.safeGetReflector(reflectorType, reflectedType);
        if (result == null) {
            throw new ReflectionException("Could not find a " + ClassUtils.getUnqualifiedClassName((Class)reflectorType) + " that can reflect " + ObjectUtils.getObjectDescription((Object)reflectedType));
        }
        return result;
    }

    private Reflector safeGetReflector(Class reflectorType, Class reflectedType) {
        for (int i = 0; i < this.getComponents().length; ++i) {
            Reflector component = (Reflector)this.getComponents()[i];
            if (!ReflectorUtils.isReflectable(component, reflectedType, reflectorType)) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Using " + component.getClass().getName() + " to reflect " + ObjectUtils.getObjectDescription((Object)reflectedType)));
            }
            return component;
        }
        return null;
    }

    protected BeanReflector getBeanReflector(Object bean) {
        return (BeanReflector)this.getReflector(class$net$sf$morph$reflect$BeanReflector == null ? (class$net$sf$morph$reflect$BeanReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.BeanReflector")) : class$net$sf$morph$reflect$BeanReflector, bean.getClass());
    }

    protected ContainerReflector getContainerReflector(Object bean) {
        return (ContainerReflector)this.getReflector(class$net$sf$morph$reflect$ContainerReflector == null ? (class$net$sf$morph$reflect$ContainerReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.ContainerReflector")) : class$net$sf$morph$reflect$ContainerReflector, bean.getClass());
    }

    protected ContainerReflector getContainerReflectorForClass(Class reflectedClass) {
        return (ContainerReflector)this.getReflector(class$net$sf$morph$reflect$ContainerReflector == null ? (class$net$sf$morph$reflect$ContainerReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.ContainerReflector")) : class$net$sf$morph$reflect$ContainerReflector, reflectedClass);
    }

    protected GrowableContainerReflector getGrowableContainerReflector(Object bean) {
        return (GrowableContainerReflector)this.getReflector(class$net$sf$morph$reflect$GrowableContainerReflector == null ? (class$net$sf$morph$reflect$GrowableContainerReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.GrowableContainerReflector")) : class$net$sf$morph$reflect$GrowableContainerReflector, bean.getClass());
    }

    protected SizableReflector getSizableReflector(Object bean) {
        return (SizableReflector)this.getReflector(class$net$sf$morph$reflect$SizableReflector == null ? (class$net$sf$morph$reflect$SizableReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.SizableReflector")) : class$net$sf$morph$reflect$SizableReflector, bean.getClass());
    }

    protected IndexedContainerReflector getIndexedContainerReflector(Object bean) {
        return (IndexedContainerReflector)this.getReflector(class$net$sf$morph$reflect$IndexedContainerReflector == null ? (class$net$sf$morph$reflect$IndexedContainerReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.IndexedContainerReflector")) : class$net$sf$morph$reflect$IndexedContainerReflector, bean.getClass());
    }

    protected MutableIndexedContainerReflector getMutableIndexedContainerReflector(Object bean) {
        return (MutableIndexedContainerReflector)this.getReflector(class$net$sf$morph$reflect$MutableIndexedContainerReflector == null ? (class$net$sf$morph$reflect$MutableIndexedContainerReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.MutableIndexedContainerReflector")) : class$net$sf$morph$reflect$MutableIndexedContainerReflector, bean.getClass());
    }

    protected InstantiatingReflector getInstantiatingReflectorForClass(Class clazz) {
        return (InstantiatingReflector)this.getReflector(class$net$sf$morph$reflect$InstantiatingReflector == null ? (class$net$sf$morph$reflect$InstantiatingReflector = SimpleDelegatingReflector.class$("net.sf.morph.reflect.InstantiatingReflector")) : class$net$sf$morph$reflect$InstantiatingReflector, clazz);
    }

    public Object[] getComponents() {
        if (super.getComponents() == null) {
            this.setComponents(this.createDefaultComponents());
        }
        return super.getComponents();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

