/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.ContainerReflector;
import net.sf.morph.reflect.reflectors.BaseBeanReflector;
import net.sf.morph.reflect.support.ResultSetIterator;
import net.sf.morph.transform.TransformationException;

public class ResultSetReflector
extends BaseBeanReflector
implements BeanReflector,
ContainerReflector {
    private static final Class[] REFLECTABLE_TYPES = new Class[]{class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = ResultSetReflector.class$("java.sql.ResultSet")) : class$java$sql$ResultSet};
    static /* synthetic */ Class class$java$sql$ResultSet;

    private ResultSet getResultSet(Object bean) {
        return (ResultSet)bean;
    }

    private ResultSetMetaData getMetaData(Object bean) throws Exception {
        return this.getResultSet(bean).getMetaData();
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        return class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = ResultSetReflector.class$("java.sql.ResultSet")) : class$java$sql$ResultSet;
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        return new ResultSetIterator((ResultSet)container);
    }

    private int getIndexForColumn(Object bean, String propertyName) throws Exception {
        int numColumns = this.getMetaData(bean).getColumnCount();
        String lowerCasePropertyName = propertyName.toLowerCase();
        for (int i = 1; i < numColumns; ++i) {
            if (!lowerCasePropertyName.equals(this.getMetaData(bean).getColumnLabel(i).toLowerCase())) continue;
            return i;
        }
        throw new TransformationException("The propertyName you specified '" + propertyName + "' was not found to be a column in the given ResultSet");
    }

    protected String[] getPropertyNamesImpl(Object bean) throws Exception {
        ResultSetMetaData meta = this.getMetaData(bean);
        int numColumns = meta.getColumnCount();
        String[] propertyNames = new String[numColumns];
        for (int i = 0; i < propertyNames.length; ++i) {
            propertyNames[i] = meta.getColumnName(i + 1).toLowerCase();
        }
        return propertyNames;
    }

    protected Class getTypeImpl(Object bean, String propertyName) throws Exception {
        return Class.forName(this.getMetaData(bean).getColumnClassName(this.getIndexForColumn(bean, propertyName)));
    }

    protected boolean isWriteableImpl(Object bean, String propertyName) throws Exception {
        return this.getMetaData(bean).isWritable(this.getIndexForColumn(bean, propertyName));
    }

    protected Object getImpl(Object bean, String propertyName) throws Exception {
        ResultSet rs = this.getResultSet(bean);
        Object obj = rs.getObject(propertyName);
        if (obj instanceof Blob) {
            obj = rs.getBytes(propertyName);
        } else if (obj instanceof Clob) {
            obj = rs.getString(propertyName);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            obj = rs.getTimestamp(propertyName);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.DATE")) {
            int index = this.getIndexForColumn(bean, propertyName);
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(propertyName) : rs.getDate(propertyName);
        } else if (obj != null && obj instanceof Date) {
            int index = this.getIndexForColumn(bean, propertyName);
            if ("java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
                obj = rs.getTimestamp(propertyName);
            }
        }
        return obj;
    }

    protected void setImpl(Object bean, String propertyName, Object value) throws Exception {
        this.getResultSet(bean).updateObject(propertyName, value);
    }

    protected Class[] getReflectableClassesImpl() throws Exception {
        return REFLECTABLE_TYPES;
    }

    public boolean isStrictlyTyped() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

