/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.ContainerReflector;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.reflectors.BaseBeanReflector;
import net.sf.morph.reflect.support.MethodHolder;
import net.sf.morph.reflect.support.ObjectIterator;
import net.sf.morph.reflect.support.ReflectionInfo;
import net.sf.morph.util.ClassUtils;

public class ObjectReflector
extends BaseBeanReflector
implements InstantiatingReflector,
ContainerReflector {
    private static final Class[] REFLECTABLE_TYPES = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ObjectReflector.class$("java.lang.Object")) : class$java$lang$Object};
    private boolean allowNullPrimitiveAssignment = true;
    private static final Map reflectionCache = new WeakHashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$NullPointerException;
    static /* synthetic */ Class class$java$lang$ArrayIndexOutOfBoundsException;

    public Class[] getReflectableClassesImpl() {
        return REFLECTABLE_TYPES;
    }

    protected String[] getPropertyNamesImpl(Object bean) throws Exception {
        String[] propertyNames = this.getReflectionInfo(bean.getClass()).getPropertyNames();
        ArrayList<String> propertyNamesWithoutClass = new ArrayList<String>();
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("class".equals(propertyNames[i])) continue;
            propertyNamesWithoutClass.add(propertyNames[i]);
        }
        return propertyNamesWithoutClass.toArray(new String[propertyNamesWithoutClass.size()]);
    }

    private Method getMutator(Object bean, String propertyName) throws Exception {
        return this.getMethodHolder(bean, propertyName).getMutator();
    }

    private Method getAccessor(Object bean, String propertyName) throws Exception {
        return this.getMethodHolder(bean, propertyName).getAccessor();
    }

    private Method getIndexedMutator(Object bean, String propertyName) throws Exception {
        return this.getMethodHolder(bean, propertyName).getIndexedMutator();
    }

    private Method getIndexedAccessor(Object bean, String propertyName) throws Exception {
        return this.getMethodHolder(bean, propertyName).getIndexedAccessor();
    }

    private MethodHolder getMethodHolder(Object bean, String propertyName) {
        return this.getReflectionInfo(bean.getClass()).getMethodHolder(propertyName);
    }

    protected Class getTypeImpl(Object bean, String propertyName) throws Exception {
        if (this.getReflectionInfo(bean.getClass()).isWriteable(propertyName)) {
            Method mutator = this.getMutator(bean, propertyName);
            if (mutator == null) {
                return ClassUtils.getArrayClass(this.getIndexedMutator(bean, propertyName).getParameterTypes()[1]);
            }
            return mutator.getParameterTypes()[0];
        }
        Method accessor = this.getAccessor(bean, propertyName);
        if (accessor == null) {
            Method indexedAccessor = this.getIndexedAccessor(bean, propertyName);
            return ClassUtils.getArrayClass(indexedAccessor.getReturnType());
        }
        return accessor.getReturnType();
    }

    protected boolean isReadableImpl(Object bean, String propertyName) throws Exception {
        return this.getReflectionInfo(bean.getClass()).isReadable(propertyName);
    }

    protected boolean isWriteableImpl(Object bean, String propertyName) throws Exception {
        return this.getReflectionInfo(bean.getClass()).isWriteable(propertyName);
    }

    protected Object getImpl(Object bean, String propertyName) throws Exception {
        ReflectionInfo reflectionInfo = this.getReflectionInfo(bean.getClass());
        if (reflectionInfo.getMethodHolder(propertyName).getAccessor() != null) {
            return reflectionInfo.get(bean, propertyName);
        }
        ArrayList<Object> contents = new ArrayList<Object>();
        boolean hasMoreElements = true;
        Exception exception = null;
        while (hasMoreElements) {
            try {
                Object value = reflectionInfo.get(bean, propertyName, new Integer(contents.size()));
                contents.add(value);
            }
            catch (Exception e) {
                exception = e;
                hasMoreElements = false;
            }
        }
        if (contents.size() == 0) {
            if (this.isExceptionOfType(exception, class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = ObjectReflector.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException)) {
                return null;
            }
            if (this.isExceptionOfType(exception, class$java$lang$ArrayIndexOutOfBoundsException == null ? (class$java$lang$ArrayIndexOutOfBoundsException = ObjectReflector.class$("java.lang.ArrayIndexOutOfBoundsException")) : class$java$lang$ArrayIndexOutOfBoundsException)) {
                return ClassUtils.createArray(this.getType(bean, propertyName).getComponentType(), (int)0);
            }
            throw (Exception)exception.fillInStackTrace();
        }
        if (this.isExceptionOfType(exception, class$java$lang$ArrayIndexOutOfBoundsException == null ? (class$java$lang$ArrayIndexOutOfBoundsException = ObjectReflector.class$("java.lang.ArrayIndexOutOfBoundsException")) : class$java$lang$ArrayIndexOutOfBoundsException)) {
            Object array = ClassUtils.createArray(this.getType(bean, propertyName).getComponentType(), (int)contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                Array.set(array, i, contents.get(i));
            }
            return array;
        }
        throw (Exception)exception.fillInStackTrace();
    }

    private boolean isExceptionOfType(Exception exception, Class type) {
        return exception instanceof InvocationTargetException && type.isInstance(((InvocationTargetException)exception).getTargetException());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setImpl(Object bean, String propertyName, Object value) throws Exception {
        if (this.isPrimitiveSetter(bean, propertyName) && value == null) {
            if (!this.isAllowNullPrimitiveAssignment()) throw new ReflectionException("Cannot set the primitive property " + propertyName + " to null");
            if (!this.log.isWarnEnabled()) return;
            this.log.warn((Object)("Attempted to set primitive property " + propertyName + " to null in bean " + ObjectUtils.getObjectDescription((Object)bean)));
            return;
        } else {
            ReflectionInfo reflectionInfo = this.getReflectionInfo(bean.getClass());
            if (reflectionInfo.getMethodHolder(propertyName).getMutator() != null) {
                reflectionInfo.set(bean, propertyName, value);
                return;
            } else {
                if (value == null) return;
                for (int i = 0; i < Array.getLength(value); ++i) {
                    reflectionInfo.set(bean, propertyName, new Integer(i), Array.get(value, i));
                }
            }
        }
    }

    protected Object newInstanceImpl(Class clazz, Object parameters) throws Exception {
        return clazz.newInstance();
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        return class$java$lang$Object == null ? (class$java$lang$Object = ObjectReflector.class$("java.lang.Object")) : class$java$lang$Object;
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        return new ObjectIterator(container);
    }

    protected boolean isPrimitiveSetter(Object bean, String propertyName) throws Exception {
        Method mutator = this.getMutator(bean, propertyName);
        if (mutator == null) {
            if (this.getIndexedMutator(bean, propertyName) == null) {
                throw new IllegalArgumentException(propertyName + " does not have any mutators, so it doesn't make sense to be checking if the setter for the property is primtive, since the property doesn't exist");
            }
            return false;
        }
        return mutator.getParameterTypes()[0].isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReflectionInfo getReflectionInfo(Class clazz) {
        Map map = reflectionCache;
        synchronized (map) {
            ReflectionInfo reflectionInfo = (ReflectionInfo)reflectionCache.get(clazz);
            if (reflectionInfo == null) {
                reflectionInfo = new ReflectionInfo(clazz);
                reflectionCache.put(clazz, reflectionInfo);
            }
            return reflectionInfo;
        }
    }

    public boolean isStrictlyTyped() {
        return true;
    }

    public boolean isAllowNullPrimitiveAssignment() {
        return this.allowNullPrimitiveAssignment;
    }

    public void setAllowNullPrimitiveAssignment(boolean allowNullPrimitiveAssignment) {
        this.allowNullPrimitiveAssignment = allowNullPrimitiveAssignment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

