/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.GrowableContainerReflector;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.SizableReflector;
import net.sf.morph.reflect.reflectors.BaseReflector;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.StringUtils;

public class MapReflector
extends BaseReflector
implements InstantiatingReflector,
SizableReflector,
GrowableContainerReflector,
BeanReflector {
    public static final String IMPLICIT_PROPERTY_ENTRIES = "entries";
    public static final String IMPLICIT_PROPERTY_KEYS = "keys";
    public static final String IMPLICIT_PROPERTY_VALUES = "values";
    public static final String EXTRACT_VALUES = "EXTRACT_VALUES";
    public static final String EXTRACT_ENTRIES = "EXTRACT_ENTRIES";
    public static final String EXTRACT_KEYS = "EXTRACT_KEYS";
    public static final String DEFAULT_MAP_TREATMENT = "EXTRACT_VALUES";
    private static final Class[] REFLECTABLE_TYPES = new Class[]{class$java$util$Map == null ? (class$java$util$Map = MapReflector.class$("java.util.Map")) : class$java$util$Map};
    protected static String[] MAP_TREATMENTS = new String[]{"EXTRACT_VALUES", "EXTRACT_ENTRIES", "EXTRACT_KEYS"};
    private String mapTreatment;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$SortedMap;

    public MapReflector() {
        this("EXTRACT_VALUES");
    }

    public MapReflector(String mapTreatment) {
        this.setMapTreatment(mapTreatment);
    }

    protected Map getMap(Object container) {
        return (Map)container;
    }

    protected int getSizeImpl(Object container) throws Exception {
        return this.getMap(container).size();
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        return class$java$lang$Object == null ? (class$java$lang$Object = MapReflector.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Class[] getReflectableClassesImpl() {
        return REFLECTABLE_TYPES;
    }

    protected Object newInstanceImpl(Class interfaceClass, Object parameters) throws Exception {
        if (interfaceClass == (class$java$util$Map == null ? (class$java$util$Map = MapReflector.class$("java.util.Map")) : class$java$util$Map)) {
            return new HashMap();
        }
        if (interfaceClass == (class$java$util$SortedMap == null ? (class$java$util$SortedMap = MapReflector.class$("java.util.SortedMap")) : class$java$util$SortedMap)) {
            return new TreeMap();
        }
        return super.newInstanceImpl(interfaceClass, parameters);
    }

    protected boolean addImpl(Object container, Object value) throws Exception {
        if (this.isExtractEntries()) {
            if (!(value instanceof Map.Entry)) {
                throw new IllegalArgumentException(ObjectUtils.getObjectDescription((Object)value) + " cannot be added to the Map because it is not of type java.util.Map.Entry");
            }
            Map.Entry entry = (Map.Entry)value;
            Object returnVal = this.getMap(container).put(entry.getKey(), entry.getValue());
            return ObjectUtils.equals((Object)value, returnVal);
        }
        if (this.isExtractKeys()) {
            Object returnVal = this.getMap(container).put(value, null);
            return ObjectUtils.equals((Object)value, returnVal);
        }
        if (this.isExtractValues()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("The " + ObjectUtils.getObjectDescription((Object)this) + " is set to " + this.getMapTreatment() + " so " + ObjectUtils.getObjectDescription((Object)value) + " will be added to the Map with a null key"));
            }
            Object returnVal = this.getMap(container).put(null, value);
            return ObjectUtils.equals((Object)value, (Object)returnVal);
        }
        throw new ReflectionException("Unknown map treatment '" + this.getMapTreatment() + "'");
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        if (this.isExtractEntries()) {
            return this.getMap(container).entrySet().iterator();
        }
        if (this.isExtractKeys()) {
            return this.getMap(container).keySet().iterator();
        }
        if (this.isExtractValues()) {
            return this.getMap(container).values().iterator();
        }
        throw new ReflectionException("Invalid mapTreatment: " + this.getMapTreatment());
    }

    protected String[] getPropertyNamesImpl(Object bean) throws Exception {
        Set keys = this.getMap(bean).keySet();
        return keys.toArray(new String[keys.size()]);
    }

    protected Class getTypeImpl(Object bean, String propertyName) throws Exception {
        return class$java$lang$Object == null ? (class$java$lang$Object = MapReflector.class$("java.lang.Object")) : class$java$lang$Object;
    }

    protected boolean isReadableImpl(Object bean, String propertyName) throws Exception {
        return true;
    }

    protected boolean isWriteableImpl(Object bean, String propertyName) throws Exception {
        return true;
    }

    protected Object getImpl(Object bean, String propertyName) throws Exception {
        Object value = this.getMap(bean).get(propertyName);
        if (propertyName.equals(IMPLICIT_PROPERTY_VALUES) && value == null) {
            return this.getMap(bean).values();
        }
        if (propertyName.equals(IMPLICIT_PROPERTY_KEYS) && value == null) {
            return this.getMap(bean).keySet();
        }
        if (propertyName.equals(IMPLICIT_PROPERTY_ENTRIES) && value == null) {
            return this.getMap(bean).entrySet();
        }
        return value;
    }

    protected void setImpl(Object bean, String propertyName, Object value) throws Exception {
        this.getMap(bean).put(propertyName, value);
    }

    public String getMapTreatment() {
        return this.mapTreatment;
    }

    public void setMapTreatment(String mapTreatment) throws ReflectionException {
        if (!ContainerUtils.contains(MAP_TREATMENTS, (Object)mapTreatment)) {
            throw new ReflectionException("Invalid value for the mapTreatment attribute.  Valid values are: " + StringUtils.englishJoin(MAP_TREATMENTS));
        }
        this.mapTreatment = mapTreatment;
    }

    public boolean isExtractEntries() {
        return EXTRACT_ENTRIES.equals(this.getMapTreatment());
    }

    public boolean isExtractKeys() {
        return EXTRACT_KEYS.equals(this.getMapTreatment());
    }

    public boolean isExtractValues() {
        return "EXTRACT_VALUES".equals(this.getMapTreatment());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

