/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.DecoratedReflector;
import net.sf.morph.reflect.IndexedContainerReflector;
import net.sf.morph.reflect.MutableIndexedContainerReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.reflect.SizableReflector;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.StringUtils;
import net.sf.morph.wrap.Wrapper;
import net.sf.morph.wrap.support.DefaultWrapperInvocationHandler;
import net.sf.morph.wrap.support.WrapperInvocationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseReflector
implements Reflector,
DecoratedReflector {
    private boolean initialized;
    private boolean cachingIsReflectableCalls = true;
    private String reflectorName;
    private transient Class[] reflectableClasses;
    private transient Map reflectableCallCache;
    protected transient Log log;
    static /* synthetic */ Class class$net$sf$morph$reflect$Reflector;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$String;

    public BaseReflector() {
        this.setInitialized(false);
        this.setReflectorName(null);
    }

    protected void initializeImpl() throws Exception {
    }

    protected final void initialize() throws ReflectionException {
        if (!this.initialized) {
            if (this.isPerformingLogging() && this.log.isInfoEnabled()) {
                this.log.info((Object)("Initializing reflector " + ObjectUtils.getObjectDescription((Object)this)));
            }
            try {
                this.initializeImpl();
                this.reflectableClasses = this.getReflectableClassesImpl();
                this.reflectableCallCache = Collections.synchronizedMap(new HashMap());
                this.setInitialized(true);
            }
            catch (ReflectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                    throw (RuntimeException)e;
                }
                throw new ReflectionException("Could not initialize " + ObjectUtils.getObjectDescription((Object)this), e);
            }
        }
    }

    public final Class[] getReflectableClasses() {
        this.initialize();
        return this.reflectableClasses;
    }

    protected abstract Class[] getReflectableClassesImpl() throws Exception;

    public final Wrapper getWrapper(Object object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating wrapper for " + ObjectUtils.getObjectDescription((Object)object)));
        }
        if (object == null) {
            return null;
        }
        this.checkIsReflectable(object);
        try {
            return this.getWrapperImpl(object);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to create wrapper for " + ObjectUtils.getObjectDescription((Object)object), e);
        }
    }

    protected Wrapper getWrapperImpl(Object object) throws Exception {
        WrapperInvocationHandler invocationHandler = this.createWrapperInvocationHandler(object);
        return (Wrapper)Proxy.newProxyInstance(object.getClass().getClassLoader(), invocationHandler.getInterfaces(object), (InvocationHandler)invocationHandler);
    }

    protected WrapperInvocationHandler createWrapperInvocationHandler(Object object) {
        return new DefaultWrapperInvocationHandler(object, this);
    }

    public final boolean isReflectable(Class reflectedType) throws ReflectionException {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Testing reflectability of " + ObjectUtils.getObjectDescription((Object)reflectedType)));
        }
        return this.isReflectableInternal(reflectedType);
    }

    protected boolean isReflectableImpl(Class reflectedType) throws Exception {
        return ClassUtils.inheritanceContains(this.getReflectableClasses(), reflectedType);
    }

    private boolean isReflectableInternal(Class reflectedType) {
        Boolean isReflectable;
        this.initialize();
        if (reflectedType == null) {
            throw new ReflectionException("Cannot determine if a null reflectedType is reflectable; please supply a reflectedType to the " + this.getClass().getName() + ".isReflectable method");
        }
        if (this.isCachingIsReflectableCalls() && (isReflectable = (Boolean)this.getReflectableCallCache().get(reflectedType)) != null) {
            return isReflectable;
        }
        try {
            boolean isReflectable2 = this.isReflectableImpl(reflectedType);
            if (this.isCachingIsReflectableCalls()) {
                this.getReflectableCallCache().put(reflectedType, new Boolean(isReflectable2));
            }
            return isReflectable2;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to determine if class '" + reflectedType.getClass().getName() + "' is reflectable", e);
        }
    }

    public final boolean isReflectable(Class reflectedType, Class reflectorType) throws ReflectionException {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Testing if " + ObjectUtils.getObjectDescription((Object)reflectedType) + " can be reflected with a " + ObjectUtils.getObjectDescription((Object)reflectorType)));
        }
        if (reflectedType == null) {
            throw new ReflectionException("Cannot determine if a null reflectedType is reflectable; please supply a reflectedType to the " + this.getClass().getName() + ".isReflectable method");
        }
        if (reflectorType != null && !(class$net$sf$morph$reflect$Reflector == null ? (class$net$sf$morph$reflect$Reflector = BaseReflector.class$("net.sf.morph.reflect.Reflector")) : class$net$sf$morph$reflect$Reflector).isAssignableFrom(reflectorType)) {
            throw new ReflectionException("The reflectorType you specified, " + ObjectUtils.getObjectDescription((Object)reflectorType) + ", is invalid.  It must be a child of " + ObjectUtils.getObjectDescription((Object)(class$net$sf$morph$reflect$Reflector == null ? (class$net$sf$morph$reflect$Reflector = BaseReflector.class$("net.sf.morph.reflect.Reflector")) : class$net$sf$morph$reflect$Reflector)));
        }
        try {
            return reflectorType == null ? this.isReflectableImpl(reflectedType) : this.isReflectableImpl(reflectedType, reflectorType);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to determine if reflectedType '" + reflectedType.getClass().getName() + "' is reflectable", e);
        }
    }

    protected boolean isReflectableImpl(Class reflectedType, Class reflectorType) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void checkIsReflectable(Object object) throws ReflectionException {
        if (!this.isReflectableInternal(object.getClass())) {
            throw new ReflectionException("Cannot reflect object " + ObjectUtils.getObjectDescription((Object)object) + " using reflector " + ObjectUtils.getObjectDescription((Object)this));
        }
    }

    public final Object newInstance(Class clazz, Object parameters) {
        if (clazz == null) {
            throw new ReflectionException("You must specify the class for which a new instance is to be created");
        }
        if (!this.isReflectableInternal(clazz)) {
            throw new ReflectionException(ObjectUtils.getObjectDescription((Object)clazz) + " is not reflectable by reflector " + ObjectUtils.getObjectDescription((Object)this));
        }
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating new instance of '" + ObjectUtils.getObjectDescription((Object)clazz) + "(parameters " + ObjectUtils.getObjectDescription((Object)parameters) + ")"));
        }
        try {
            Object result = this.newInstanceImpl(clazz, parameters);
            if (!clazz.isInstance(result)) {
                throw new ReflectionException(ObjectUtils.getObjectDescription((Object)result) + " is not an instance of " + clazz);
            }
            return result;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to create new instance of " + ObjectUtils.getObjectDescription((Object)clazz) + "(parameters " + ObjectUtils.getObjectDescription((Object)parameters) + ")", e);
        }
    }

    protected final Object newInstanceImpl(Class clazz) throws Exception {
        throw new UnsupportedOperationException("Deprecated method - use BaseReflector.newInstanceImpl(Class, Object) instead");
    }

    protected Object newInstanceImpl(Class clazz, Object parameters) throws Exception {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating new instance of " + ObjectUtils.getObjectDescription((Object)clazz)));
        }
        return clazz.newInstance();
    }

    public final String[] getPropertyNames(Object bean) throws ReflectionException {
        if (bean == null) {
            throw new ReflectionException("Cannot determine the properties of a null bean.  Please supply a bean to the " + this.getClass().getName() + ".getPropertyNames method");
        }
        this.checkIsReflectable(bean);
        try {
            String[] propertyNames = this.getPropertyNamesImpl(bean);
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Properties of bean " + ObjectUtils.getObjectDescription((Object)bean) + " are " + StringUtils.englishJoin(propertyNames)));
            }
            return propertyNames;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to get property names for bean " + ObjectUtils.getObjectDescription((Object)bean), e);
        }
    }

    protected String[] getPropertyNamesImpl(Object bean) throws Exception {
        if (this instanceof IndexedContainerReflector) {
            int size = ((IndexedContainerReflector)((Object)this)).getSize(bean);
            String[] propertyNames = new String[size];
            for (int i = 0; i < size; ++i) {
                propertyNames[i] = Integer.toString(i);
            }
            return propertyNames;
        }
        throw new UnsupportedOperationException();
    }

    public final boolean isReadable(Object bean, String propertyName) throws ReflectionException {
        if (bean == null && ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply non-null arguments to the " + this.getClass().getName() + ".isReadable method");
        }
        if (bean == null) {
            throw new ReflectionException("Cannot determine if property '" + propertyName + "' is readable since no bean was specified");
        }
        if (ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply a property name to test for readability for bean " + ObjectUtils.getObjectDescription((Object)bean));
        }
        this.checkIsReflectable(bean);
        try {
            boolean isReadable = this instanceof SizableReflector && propertyName.equals("size") ? true : (this instanceof BeanReflector && (propertyName.equals("class") || propertyName.equals("propertyNames") || propertyName.equals("this")) ? true : this.isReadableImpl(bean, propertyName));
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Property '" + propertyName + "' is" + (isReadable ? " " : " not ") + "readable in bean " + ObjectUtils.getObjectDescription((Object)bean)));
            }
            return isReadable;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable determine if property '" + propertyName + "' is readable in bean " + ObjectUtils.getObjectDescription((Object)bean), e);
        }
    }

    protected boolean isReadableImpl(Object bean, String propertyName) throws Exception {
        return this instanceof IndexedContainerReflector ? this.isValidIndex(bean, propertyName) : ContainerUtils.contains(this.getPropertyNames(bean), (Object)propertyName);
    }

    public final boolean isWriteable(Object bean, String propertyName) {
        if (bean == null && ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply non-null arguments to the " + this.getClass().getName() + ".isWriteable method");
        }
        if (bean == null) {
            throw new ReflectionException("Cannot determine if property '" + propertyName + "' is writeable since no bean was specified");
        }
        if (ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply a property name to test for writeability for bean " + ObjectUtils.getObjectDescription((Object)bean));
        }
        this.checkIsReflectable(bean);
        try {
            Boolean isWriteable = null;
            Exception exception = null;
            try {
                isWriteable = new Boolean(this.isWriteableImpl(bean, propertyName));
            }
            catch (Exception e) {
                exception = e;
            }
            if (isWriteable == null) {
                if (this instanceof SizableReflector && propertyName.equals("size")) {
                    return false;
                }
                if (this instanceof BeanReflector && ("class".equals(propertyName) || "propertyNames".equals(propertyName) || "this".equals(propertyName))) {
                    return false;
                }
            }
            if (exception == null) {
                if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Property '" + propertyName + "' is" + (isWriteable != false ? " " : " not ") + "writeable in bean " + ObjectUtils.getObjectDescription((Object)bean)));
                }
                return isWriteable;
            }
            throw exception;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable determine if property '" + propertyName + "' is writeable in bean " + ObjectUtils.getObjectDescription((Object)bean), e);
        }
    }

    protected boolean isWriteableImpl(Object bean, String propertyName) throws Exception {
        return (!(this instanceof IndexedContainerReflector) || this instanceof MutableIndexedContainerReflector) && this.isReadableImpl(bean, propertyName);
    }

    protected boolean isValidIndex(Object bean, String propertyName) throws ReflectionException {
        try {
            int index = Integer.parseInt(propertyName);
            return index >= 0 && index < this.getSize(bean);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public final void set(Object bean, String propertyName, Object propertyValue) throws ReflectionException {
        block12: {
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Setting property '" + propertyName + "' of bean " + ObjectUtils.getObjectDescription((Object)bean) + " to " + ObjectUtils.getObjectDescription((Object)propertyValue)));
            }
            if (bean == null && ObjectUtils.isEmpty((Object)propertyName)) {
                throw new ReflectionException("Please supply non-null arguments to the " + this.getClass().getName() + ".set method");
            }
            if (bean == null) {
                throw new ReflectionException("Cannot retrieve property '" + propertyName + "' since no bean was specified");
            }
            if (ObjectUtils.isEmpty((Object)propertyName)) {
                throw new ReflectionException("Please supply a property name to retrieve from bean " + ObjectUtils.getObjectDescription((Object)bean));
            }
            this.checkIsReflectable(bean);
            try {
                Object currentValue = this.get(bean, propertyName);
                if ((propertyValue == currentValue || ClassUtils.isImmutable(this.getType(bean, propertyName)) && ObjectUtils.equals((Object)propertyValue, (Object)currentValue)) && ("this".equals(propertyName) || ContainerUtils.contains(this.getPropertyNames(bean), (Object)propertyName))) {
                    return;
                }
            }
            catch (ReflectionException e) {
                if (!this.isPerformingLogging() || !this.log.isTraceEnabled()) break block12;
                this.log.trace((Object)("Ignoring exception encountered getting property " + propertyName + " for object " + ObjectUtils.getObjectDescription((Object)bean)));
            }
        }
        if (!this.isWriteable(bean, propertyName)) {
            throw new ReflectionException("The property '" + propertyName + "' is not writeable in bean " + ObjectUtils.getObjectDescription((Object)bean));
        }
        try {
            this.setImpl(bean, propertyName, propertyValue);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to set property '" + propertyName + "' of bean " + ObjectUtils.getObjectDescription((Object)bean) + " to " + propertyValue, e);
        }
    }

    protected void setImpl(Object bean, String propertyName, Object value) throws Exception {
        if (!(this instanceof MutableIndexedContainerReflector)) {
            throw new UnsupportedOperationException();
        }
        ((MutableIndexedContainerReflector)((Object)this)).set(bean, Integer.parseInt(propertyName), value);
    }

    public final Object get(Object bean, String propertyName) throws ReflectionException {
        if (bean == null && ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply non-null arguments to the " + this.getClass().getName() + ".get method");
        }
        if (bean == null) {
            throw new ReflectionException("Cannot retrieve property '" + propertyName + "' from a null object");
        }
        if (ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply a property name to retrieve from bean " + ObjectUtils.getObjectDescription((Object)bean));
        }
        this.checkIsReflectable(bean);
        try {
            Object value = null;
            Exception exception = null;
            try {
                if (!this.isReadable(bean, propertyName)) {
                    throw new ReflectionException("The property '" + propertyName + "' is not readable in bean " + ObjectUtils.getObjectDescription((Object)bean) + " using reflector " + ObjectUtils.getObjectDescription((Object)this));
                }
                value = this.getImpl(bean, propertyName);
            }
            catch (Exception e) {
                exception = e;
            }
            if (value == null && this instanceof BeanReflector && propertyName.equals("class")) {
                return bean.getClass();
            }
            if (value == null && this instanceof BeanReflector && propertyName.equals("propertyNames")) {
                return this.getPropertyNames(bean);
            }
            if (value == null && this instanceof BeanReflector && propertyName.equals("this")) {
                return bean;
            }
            if (value == null && this instanceof SizableReflector && propertyName.equals("size")) {
                return new Integer(this.getSize(bean));
            }
            if (exception == null) {
                if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Property '" + propertyName + "' has value " + ObjectUtils.getObjectDescription((Object)value) + " in bean " + ObjectUtils.getObjectDescription((Object)bean)));
                }
                return value;
            }
            throw exception;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to retrieve property '" + propertyName + "' from bean " + ObjectUtils.getObjectDescription((Object)bean), e);
        }
    }

    protected Object getImpl(Object bean, String propertyName) throws Exception {
        if (!(this instanceof IndexedContainerReflector)) {
            throw new UnsupportedOperationException();
        }
        return "class".equals(propertyName) || "size".equals(propertyName) || "this".equals(propertyName) ? null : this.get(bean, Integer.parseInt(propertyName));
    }

    public final Class getType(Object bean, String propertyName) throws ReflectionException {
        if (bean == null && ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply non-null arguments to the " + this.getClass().getName() + ".getType method");
        }
        if (bean == null) {
            throw new ReflectionException("Cannot determine type of property '" + propertyName + "' since no bean was specified");
        }
        if (ObjectUtils.isEmpty((Object)propertyName)) {
            throw new ReflectionException("Please supply a property name of bean " + ObjectUtils.getObjectDescription((Object)bean) + " for which you would like to know the type");
        }
        this.checkIsReflectable(bean);
        boolean hasPropertyDefined = ContainerUtils.contains(this.getPropertyNames(bean), (Object)propertyName);
        if (!(!this.isStrictlyTyped() || hasPropertyDefined || "size".equals(propertyName) || "class".equals(propertyName) || "this".equals(propertyName) || "propertyNames".equals(propertyName))) {
            throw new ReflectionException("Cannot determine type of property '" + propertyName + "' because it is not a property of " + ObjectUtils.getObjectDescription((Object)bean));
        }
        Class type = null;
        if (!hasPropertyDefined) {
            if (propertyName.equals("class")) {
                type = class$java$lang$Class == null ? (class$java$lang$Class = BaseReflector.class$("java.lang.Class")) : class$java$lang$Class;
            } else if (propertyName.equals("propertyNames")) {
                type = array$Ljava$lang$String == null ? (array$Ljava$lang$String = BaseReflector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            } else if (propertyName.equals("this")) {
                type = ClassUtils.getClass(bean);
            } else if (propertyName.equals("size")) {
                type = Integer.TYPE;
            }
        }
        if (type == null) {
            try {
                type = this.getTypeImpl(bean, propertyName);
            }
            catch (ReflectionException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                    throw (RuntimeException)e;
                }
                throw new ReflectionException("Unable to determine type of property '" + propertyName + "' for bean " + ObjectUtils.getObjectDescription((Object)bean), e);
            }
        }
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Property '" + propertyName + "' has type " + ObjectUtils.getObjectDescription(type) + " in bean " + ObjectUtils.getObjectDescription((Object)bean)));
        }
        return type;
    }

    protected Class getTypeImpl(Object bean, String propertyName) throws Exception {
        if (this instanceof IndexedContainerReflector) {
            if (this.isValidIndex(bean, propertyName)) {
                return ((IndexedContainerReflector)((Object)this)).getContainedType(bean.getClass());
            }
            throw new ReflectionException("'" + propertyName + "' is not a valid index in the container " + ObjectUtils.getObjectDescription((Object)bean));
        }
        return ClassUtils.getClass(this.getImpl(bean, propertyName));
    }

    public final Class getContainedType(Class clazz) throws ReflectionException {
        if (clazz == null) {
            throw new ReflectionException("Can't determine the type of a null object");
        }
        try {
            Class type = this.getContainedTypeImpl(clazz);
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Contained type is " + ObjectUtils.getObjectDescription((Object)type) + " for instances of " + ObjectUtils.getObjectDescription((Object)clazz)));
            }
            return type;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not determine the type of objects contained in the container of " + ObjectUtils.getObjectDescription((Object)clazz));
        }
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final Iterator getIterator(Object container) throws ReflectionException {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Retrieving iterator for " + ObjectUtils.getObjectDescription((Object)container)));
        }
        if (container == null) {
            throw new ReflectionException("Cannot iterate through the contents of null container");
        }
        this.checkIsReflectable(container);
        try {
            return this.getIteratorImpl(container);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not retrieve iterator for " + ObjectUtils.getObjectDescription((Object)container), e);
        }
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void checkIndex(Object container, int index) throws ReflectionException {
        if (index < 0) {
            throw new ReflectionException("Must specify a non-negative index");
        }
        if (index > this.getSize(container) - 1) {
            throw new ReflectionException("Cannot access element " + index + " because the container object has only " + this.getSize(container) + " elements");
        }
    }

    public final int getSize(Object container) throws ReflectionException {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Retrieving size of " + ObjectUtils.getObjectDescription((Object)container)));
        }
        if (container == null) {
            throw new ReflectionException("Cannot determine the size of a null object");
        }
        this.checkIsReflectable(container);
        try {
            return this.getSizeImpl(container);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not determine the size of " + ObjectUtils.getObjectDescription((Object)container) + " object", e);
        }
    }

    protected int getSizeImpl(Object container) throws Exception {
        if (this instanceof BeanReflector) {
            return this.getPropertyNamesImpl(container).length;
        }
        throw new UnsupportedOperationException();
    }

    public final Object get(Object container, int index) throws ReflectionException {
        if (container == null) {
            throw new ReflectionException("Can't retrieve values from a null object");
        }
        this.checkIndex(container, index);
        this.checkIsReflectable(container);
        try {
            Object value = this.getImpl(container, index);
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Item at index " + index + " has value " + ObjectUtils.getObjectDescription((Object)value) + " in container " + ObjectUtils.getObjectDescription((Object)container)));
            }
            return value;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not retrieve element " + index + " from " + ObjectUtils.getObjectDescription((Object)container), e);
        }
    }

    protected Object getImpl(Object container, int index) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final Object set(Object container, int index, Object propertyValue) throws ReflectionException {
        block9: {
            if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
                this.log.trace((Object)("Setting item at index " + index + " for object " + ObjectUtils.getObjectDescription((Object)container) + " to value " + ObjectUtils.getObjectDescription((Object)propertyValue)));
            }
            if (container == null) {
                throw new ReflectionException("Can't set values of a null object");
            }
            this.checkIndex(container, index);
            this.checkIsReflectable(container);
            try {
                Object currentValue = this.get(container, index);
                if (propertyValue == currentValue || ClassUtils.isImmutable(this.getContainedType(container.getClass())) && ObjectUtils.equals((Object)propertyValue, (Object)currentValue)) {
                    return currentValue;
                }
            }
            catch (ReflectionException e) {
                if (!this.isPerformingLogging() || !this.log.isTraceEnabled()) break block9;
                this.log.trace((Object)("Ignoring exception encountered getting item at index " + index + " for object " + ObjectUtils.getObjectDescription((Object)container)));
            }
        }
        try {
            return this.setImpl(container, index, propertyValue);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not set element " + index + " of " + ObjectUtils.getObjectDescription((Object)container) + " to value " + ObjectUtils.getObjectDescription((Object)propertyValue), e);
        }
    }

    protected Object setImpl(Object container, int index, Object propertyValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final boolean add(Object container, Object value) throws ReflectionException {
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding item " + ObjectUtils.getObjectDescription((Object)value) + " to container " + ObjectUtils.getObjectDescription((Object)container)));
        }
        if (container == null) {
            throw new ReflectionException("Can't add values of a null object");
        }
        this.checkIsReflectable(container);
        try {
            return this.addImpl(container, value);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Could not add item " + ObjectUtils.getObjectDescription((Object)value) + " to container " + ObjectUtils.getObjectDescription((Object)container), e);
        }
    }

    protected boolean addImpl(Object container, Object value) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean isPerformingLogging() {
        return true;
    }

    public boolean isStrictlyTyped() {
        return false;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isCachingIsReflectableCalls() {
        return this.cachingIsReflectableCalls;
    }

    public void setCachingIsReflectableCalls(boolean cachingIsReflectableCalls) {
        this.cachingIsReflectableCalls = cachingIsReflectableCalls;
    }

    protected Map getReflectableCallCache() {
        return this.reflectableCallCache;
    }

    protected void setReflectableCallCache(Map reflectableCallCache) {
        this.reflectableCallCache = reflectableCallCache;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    public String getReflectorName() {
        return this.reflectorName;
    }

    public void setReflectorName(String reflectorName) {
        if (this.initialized && ObjectUtils.equals((Object)reflectorName, (Object)this.reflectorName)) {
            return;
        }
        this.reflectorName = reflectorName;
        this.log = reflectorName == null ? LogFactory.getLog(this.getClass()) : LogFactory.getLog((String)reflectorName);
    }

    public String toString() {
        String name = this.getReflectorName();
        return name == null ? super.toString() : name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

