/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.reflect.reflectors;

import java.lang.reflect.Array;
import java.util.Iterator;
import net.sf.composite.util.ArrayIterator;
import net.sf.morph.Defaults;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.ContainerReflector;
import net.sf.morph.reflect.IndexedContainerReflector;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.MutableIndexedContainerReflector;
import net.sf.morph.reflect.SizableReflector;
import net.sf.morph.reflect.reflectors.BaseContainerReflector;
import net.sf.morph.util.ClassUtils;

public class ArrayReflector
extends BaseContainerReflector
implements ContainerReflector,
IndexedContainerReflector,
MutableIndexedContainerReflector,
SizableReflector,
BeanReflector,
InstantiatingReflector {
    private SizableReflector sourceReflector;

    public ArrayReflector() {
        this.sourceReflector = Defaults.createSizableReflector();
    }

    public ArrayReflector(SizableReflector sourceReflector) {
        this.sourceReflector = sourceReflector;
    }

    protected Class[] getReflectableClassesImpl() {
        return ClassUtils.ARRAY_TYPES;
    }

    protected Iterator getIteratorImpl(Object container) throws Exception {
        return new ArrayIterator(container);
    }

    protected int getSizeImpl(Object container) throws Exception {
        return Array.getLength(container);
    }

    protected Object getImpl(Object container, int index) throws Exception {
        return Array.get(container, index);
    }

    protected Object setImpl(Object container, int index, Object propertyValue) throws Exception {
        Object oldValue = this.getImpl(container, index);
        Array.set(container, index, propertyValue);
        return oldValue;
    }

    protected Class getContainedTypeImpl(Class clazz) throws Exception {
        return ClassUtils.getContainedClass((Class)clazz);
    }

    protected boolean isReflectableImpl(Class clazz) throws Exception {
        return clazz.isArray();
    }

    protected Object newInstanceImpl(Class clazz, Object parameters) throws Exception {
        int length = parameters == null ? 0 : this.getSourceReflector().getSize(parameters);
        return ClassUtils.createArray(clazz.getComponentType(), (int)length);
    }

    public SizableReflector getSourceReflector() {
        return this.sourceReflector;
    }

    public void setSourceReflector(SizableReflector sourceReflector) {
        this.sourceReflector = sourceReflector;
    }
}

