/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.lang.languages;

import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.lang.languages.BaseLanguage;
import net.sf.morph.lang.support.ExpressionParser;
import net.sf.morph.lang.support.SimpleExpressionParser;
import net.sf.morph.reflect.BeanReflector;

public class SimpleLanguage
extends BaseLanguage {
    private static final ExpressionParser DEFAULT_EXPRESSION_PARSER = new SimpleExpressionParser();
    private ExpressionParser expressionParser;
    private BeanReflector reflector;

    protected boolean isPropertyImpl(String expression) throws Exception {
        return this.getExpressionParser().parse(expression).length == 1;
    }

    protected Class getTypeImpl(Object target, String expression) throws Exception {
        if (ObjectUtils.isEmpty((Object)expression)) {
            return target.getClass();
        }
        Object value = target;
        String[] tokens = this.getExpressionParser().parse(expression);
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            value = this.getReflector().get(value, token);
        }
        String token = tokens[tokens.length - 1];
        return this.getReflector().getType(value, token);
    }

    protected Object getImpl(Object target, String expression) throws Exception {
        if (ObjectUtils.isEmpty((Object)expression)) {
            return target;
        }
        Object value = target;
        String[] tokens = this.getExpressionParser().parse(expression);
        for (int i = 0; value != null && i < tokens.length; ++i) {
            String token = tokens[i];
            value = this.getReflector().get(value, token);
        }
        return value;
    }

    protected void setImpl(Object target, String expression, Object value) throws Exception {
        if (ObjectUtils.isEmpty((Object)expression)) {
            target = value;
        }
        Object currentTarget = target;
        String[] tokens = this.getExpressionParser().parse(expression);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i == tokens.length - 1) {
                this.getReflector().set(currentTarget, token, value);
                continue;
            }
            currentTarget = this.getReflector().get(currentTarget, token);
        }
    }

    public synchronized ExpressionParser getExpressionParser() {
        if (this.expressionParser == null) {
            this.setExpressionParser(DEFAULT_EXPRESSION_PARSER);
        }
        return this.expressionParser;
    }

    public synchronized void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public synchronized BeanReflector getReflector() {
        if (this.reflector == null) {
            this.setReflector(Defaults.createBeanReflector());
        }
        return this.reflector;
    }

    public synchronized void setReflector(BeanReflector reflector) {
        this.reflector = reflector;
    }
}

