/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.lang.languages;

import java.util.Locale;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.lang.DecoratedLanguage;
import net.sf.morph.lang.LanguageException;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.TransformationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseLanguage
implements DecoratedLanguage {
    private Converter converter;
    private String languageName;
    private transient Log log;
    static /* synthetic */ Class class$java$lang$Object;

    public BaseLanguage() {
        this.establishLog(null);
    }

    protected abstract boolean isPropertyImpl(String var1) throws Exception;

    protected abstract Class getTypeImpl(Object var1, String var2) throws Exception;

    protected abstract Object getImpl(Object var1, String var2) throws Exception;

    protected abstract void setImpl(Object var1, String var2, Object var3) throws Exception;

    public final boolean isProperty(String expression) throws LanguageException {
        try {
            boolean isProperty = this.isPropertyImpl(expression);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Expression '" + expression + "' denotes a" + (isProperty ? " simple property of an object" : "n expression that involves traversal of an object graph")));
            }
            return isProperty;
        }
        catch (LanguageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LanguageException("Could not determine if expression '" + expression + "' references a nested property", e);
        }
    }

    public final Class getType(Object target, String expression) throws LanguageException {
        if (target == null) {
            throw new LanguageException("The target object cannot be null");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Retrieving type of '" + expression + "' from target " + ObjectUtils.getObjectDescription((Object)target)));
        }
        try {
            Class type = this.getTypeImpl(target, expression);
            Class clazz = type == null ? (class$java$lang$Object == null ? (class$java$lang$Object = BaseLanguage.class$("java.lang.Object")) : class$java$lang$Object) : type;
            return clazz;
        }
        catch (LanguageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LanguageException("Could not retrieve type of '" + expression + "' from target " + ObjectUtils.getObjectDescription((Object)target), e);
        }
    }

    public final Object get(Object target, String expression) throws LanguageException {
        if (target == null) {
            throw new LanguageException("The target object cannot be null");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Retrieving '" + expression + "' from target " + ObjectUtils.getObjectDescription((Object)target)));
        }
        try {
            return this.getImpl(target, expression);
        }
        catch (LanguageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LanguageException("Could not retrieve '" + expression + "' from target " + ObjectUtils.getObjectDescription((Object)target), e);
        }
    }

    public final void set(Object target, String expression, Object value) throws LanguageException {
        this.set(target, expression, value, null);
    }

    public final Object get(Object target, String expression, Class destinationClass) throws LanguageException, TransformationException {
        return this.get(target, expression, destinationClass, null);
    }

    public final Object get(Object target, String expression, Class destinationClass, Locale locale) throws LanguageException, TransformationException {
        Object object = this.get(target, expression);
        return this.getConverter().convert(destinationClass, object, locale);
    }

    public final Object get(Object target, String expression, Locale locale, Class destinationClass) throws LanguageException, TransformationException {
        return this.get(target, expression, destinationClass, locale);
    }

    public void set(Object target, String expression, Object value, Locale locale) throws LanguageException, TransformationException {
        Class type;
        if (target == null) {
            throw new LanguageException("The target object cannot be null");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Setting '" + expression + "' to " + ObjectUtils.getObjectDescription((Object)value) + " on target " + ObjectUtils.getObjectDescription((Object)target)));
        }
        Object converted = (type = this.getType(target, expression)).isInstance(value) ? value : this.getConverter().convert(type, value, locale);
        try {
            this.setImpl(target, expression, converted);
        }
        catch (LanguageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LanguageException("Could not set '" + expression + "' to " + ObjectUtils.getObjectDescription((Object)value) + " on target " + ObjectUtils.getObjectDescription((Object)target), e);
        }
    }

    public Converter getConverter() {
        if (this.converter == null) {
            this.setConverter(Defaults.createConverter());
        }
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        if (ObjectUtils.equals((Object)languageName, (Object)this.languageName)) {
            return;
        }
        this.languageName = languageName;
        this.establishLog(languageName);
    }

    private void establishLog(String name) {
        this.log = name == null ? LogFactory.getLog(this.getClass()) : LogFactory.getLog((String)name);
    }

    public String toString() {
        String name = this.getLanguageName();
        return name == null ? super.toString() : name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

