/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.integration.commons.collections;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.transform.DecoratedConverter;
import org.apache.commons.collections.Transformer;

public class DecoratedConverterToTransformerAdapter
implements Transformer {
    private Class destinationClass;
    private Map destinationClassMap;
    private DecoratedConverter delegate;
    private Locale locale;
    static /* synthetic */ Class class$java$lang$Object;

    public DecoratedConverterToTransformerAdapter() {
    }

    public DecoratedConverterToTransformerAdapter(DecoratedConverter delegate) {
        this();
        this.setDelegate(delegate);
    }

    public DecoratedConverterToTransformerAdapter(DecoratedConverter delegate, Class destinationClass) {
        this(delegate);
        this.setDestinationClass(destinationClass);
    }

    public DecoratedConverterToTransformerAdapter(Class destinationClass) {
        this();
        this.setDestinationClass(destinationClass);
    }

    public Object transform(Object source) {
        return this.getDelegate().convert(this.determineDestinationClass(source), source, this.locale);
    }

    private Class determineDestinationClass(Object source) {
        if (!ObjectUtils.isEmpty((Object)this.destinationClassMap)) {
            Iterator it = this.destinationClassMap.keySet().iterator();
            while (it.hasNext()) {
                Class c = (Class)it.next();
                if (!c.isAssignableFrom(source.getClass())) continue;
                return (Class)this.destinationClassMap.get(c);
            }
        }
        Class clazz = this.destinationClass == null ? (class$java$lang$Object == null ? (class$java$lang$Object = DecoratedConverterToTransformerAdapter.class$("java.lang.Object")) : class$java$lang$Object) : this.destinationClass;
        return clazz;
    }

    public synchronized DecoratedConverter getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(Defaults.createConverter());
        }
        return this.delegate;
    }

    public synchronized void setDelegate(DecoratedConverter delegate) {
        this.delegate = delegate;
    }

    public Class getDestinationClass() {
        return this.destinationClass;
    }

    public void setDestinationClass(Class destinationClass) {
        this.destinationClass = destinationClass;
    }

    public Map getDestinationClassMap() {
        return this.destinationClassMap;
    }

    public void setDestinationClassMap(Map destinationClassMap) {
        this.destinationClassMap = destinationClassMap;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

