/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.context.Context;
import net.sf.morph.context.DelegatingContext;
import net.sf.morph.context.support.MapEntry;
import net.sf.morph.util.ContainerUtils;

public class ContextMapBridge {
    protected Object getDelegate(Context context) {
        return context instanceof DelegatingContext ? ((DelegatingContext)context).getDelegate() : null;
    }

    public int size(Context context) {
        return this.getPropertyNames(context).length;
    }

    public void clear(Context context) {
        Object delegate = this.getDelegate(context);
        if (!(delegate instanceof Map)) {
            throw new UnsupportedOperationException();
        }
        ((Map)delegate).clear();
    }

    public boolean isEmpty(Context context) {
        return ObjectUtils.isEmpty((Object)this.getPropertyNames(context));
    }

    public boolean containsKey(Context context, Object key) {
        return ContainerUtils.contains(this.getPropertyNames(context), key);
    }

    public boolean containsValue(Context context, Object value) {
        String[] propertyNames = this.getPropertyNames(context);
        if (ObjectUtils.isEmpty((Object)propertyNames)) {
            return false;
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!ObjectUtils.equals((Object)context.get(propertyNames[i]), (Object)value)) continue;
            return true;
        }
        return false;
    }

    public Collection values(Context context) {
        String[] propertyNames = this.getPropertyNames(context);
        if (ObjectUtils.isEmpty((Object)propertyNames)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> values = new ArrayList<Object>(propertyNames.length);
        for (int i = 0; i < propertyNames.length; ++i) {
            values.add(context.get(propertyNames[i]));
        }
        return values;
    }

    public void putAll(Context context, Map t) {
        this.checkContextNotNull(context);
        if (t == null || t.isEmpty()) {
            return;
        }
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.put(context, e.getKey(), e.getValue());
        }
    }

    public Set entrySet(Context context) {
        String[] propertyNames = this.getPropertyNames(context);
        if (ObjectUtils.isEmpty((Object)propertyNames)) {
            return Collections.EMPTY_SET;
        }
        Set set = ContainerUtils.createOrderedSet();
        for (int i = 0; i < propertyNames.length; ++i) {
            set.add(new MapEntry(propertyNames[i], context.get(propertyNames[i]), false));
        }
        return set;
    }

    public Set keySet(Context context) {
        String[] propertyNames = this.getPropertyNames(context);
        if (ObjectUtils.isEmpty((Object)propertyNames)) {
            return Collections.EMPTY_SET;
        }
        Set s = ContainerUtils.createOrderedSet();
        s.addAll(Arrays.asList(propertyNames));
        return s;
    }

    public Object get(Context context, Object key) {
        return this.checkContextNotNull(context).get((String)key);
    }

    public Object remove(Context context, Object key) {
        Object delegate = this.getDelegate(context);
        if (delegate instanceof Map) {
            return ((Map)delegate).remove(key);
        }
        throw new UnsupportedOperationException();
    }

    public Object put(Context context, Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Only string keys can be used");
        }
        Object originalValue = this.checkContextNotNull(context).get((String)key);
        context.set((String)key, value);
        return originalValue;
    }

    protected Context checkContextNotNull(Context context) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        return context;
    }

    protected String[] getPropertyNames(Context context) {
        return this.checkContextNotNull(context).getPropertyNames();
    }
}

