/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.context.contexts;

import net.sf.morph.Defaults;
import net.sf.morph.context.Context;
import net.sf.morph.context.ContextException;
import net.sf.morph.context.DelegatingContext;
import net.sf.morph.context.HierarchicalContext;
import net.sf.morph.context.contexts.BaseHierarchicalContext;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.util.ClassUtils;

public class ReflectorHierarchicalContext
extends BaseHierarchicalContext
implements HierarchicalContext,
DelegatingContext {
    private BeanReflector beanReflector;
    private Object delegate;

    public ReflectorHierarchicalContext() {
    }

    public ReflectorHierarchicalContext(Object delegate) {
        this();
        this.setDelegate(delegate);
    }

    public ReflectorHierarchicalContext(Context parentContext) {
        super(parentContext);
    }

    public ReflectorHierarchicalContext(Object delegate, Context parentContext) {
        super(parentContext);
        this.delegate = delegate;
    }

    protected void checkConfiguration() {
        if (this.getBeanReflector() == null) {
            throw new ContextException("The " + this.getClass().getName() + " requires a beanReflector be set using the setReflector method");
        }
        if (this.getDelegate() == null) {
            throw new ContextException("The " + this.getClass().getName() + " requires an object that can have its properties delegate.  Use the setReflected method");
        }
        if (!ClassUtils.inheritanceContains(this.getBeanReflector().getReflectableClasses(), this.getDelegate().getClass())) {
            throw new ContextException("The beanReflector of class " + this.getBeanReflector().getClass().getName() + " cannot reflect objects of class " + this.getDelegate().getClass().getName());
        }
    }

    protected String[] getPropertyNamesHierarchicalImpl() throws Exception {
        this.checkConfiguration();
        return this.getBeanReflector().getPropertyNames(this.getDelegate());
    }

    protected Object getHierarchicalImpl(String propertyName) throws Exception {
        this.checkConfiguration();
        return this.getBeanReflector().isReadable(this.getDelegate(), propertyName) ? this.getBeanReflector().get(this.getDelegate(), propertyName) : null;
    }

    protected void setHierarchicalImpl(String propertyName, Object propertyValue) throws Exception {
        this.checkConfiguration();
        this.getBeanReflector().set(this.getDelegate(), propertyName, propertyValue);
    }

    public BeanReflector getBeanReflector() {
        if (this.beanReflector == null) {
            this.beanReflector = Defaults.createBeanReflector();
        }
        return this.beanReflector;
    }

    public void setBeanReflector(BeanReflector beanReflector) {
        this.beanReflector = beanReflector;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object reflected) {
        this.delegate = reflected;
    }
}

