/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.context.contexts;

import javax.servlet.http.HttpServletRequest;
import net.sf.morph.context.contexts.ReflectorHierarchicalContext;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.reflectors.HttpSessionAttributeReflector;
import net.sf.morph.reflect.reflectors.ServletContextAttributeReflector;
import net.sf.morph.reflect.reflectors.ServletRequestAttributeReflector;
import net.sf.morph.reflect.reflectors.ServletRequestParameterReflector;

public class HttpServletContext
extends ReflectorHierarchicalContext {
    private static final BeanReflector REQUEST_PARAMETER_REFLECTOR = new ServletRequestParameterReflector();
    private static final BeanReflector REQUEST_ATTRIBUTE_REFLECTOR = new ServletRequestAttributeReflector();
    private static final BeanReflector SESSION_ATTRIBUTE_REFLECTOR = new HttpSessionAttributeReflector();
    private static final BeanReflector APPLICATION_ATTRIBUTE_REFLECTOR = new ServletContextAttributeReflector();
    private ReflectorHierarchicalContext applicationContext = new ReflectorHierarchicalContext();
    private ReflectorHierarchicalContext sessionContext;
    private ReflectorHierarchicalContext requestContext;
    private boolean reflectingRequestParameters = true;

    public HttpServletContext() {
        this.applicationContext.setBeanReflector(APPLICATION_ATTRIBUTE_REFLECTOR);
        this.sessionContext = new ReflectorHierarchicalContext();
        this.sessionContext.setBeanReflector(SESSION_ATTRIBUTE_REFLECTOR);
        this.sessionContext.setParentContext(this.applicationContext);
        this.requestContext = new ReflectorHierarchicalContext();
        this.requestContext.setBeanReflector(REQUEST_ATTRIBUTE_REFLECTOR);
        this.requestContext.setParentContext(this.sessionContext);
        this.setBeanReflector(REQUEST_PARAMETER_REFLECTOR);
        this.setParentContext(this.requestContext);
    }

    public HttpServletContext(HttpServletRequest request) {
        this();
        this.setRequest(request);
    }

    protected void setHierarchicalImpl(String propertyName, Object propertyValue) throws Exception {
        this.requestContext.set(propertyName, propertyValue);
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getDelegate();
    }

    public void setRequest(HttpServletRequest request) {
        this.applicationContext.setDelegate(request.getSession().getServletContext());
        this.sessionContext.setDelegate(request.getSession());
        this.requestContext.setDelegate(request);
        this.setDelegate(request);
    }

    public boolean isReflectingRequestParameters() {
        return this.reflectingRequestParameters;
    }

    public void setReflectingRequestParameters(boolean reflectingRequestParameters) {
        this.reflectingRequestParameters = reflectingRequestParameters;
        if (reflectingRequestParameters) {
            this.setBeanReflector(REQUEST_PARAMETER_REFLECTOR);
            this.setParentContext(this.requestContext);
        } else {
            this.setBeanReflector(REQUEST_ATTRIBUTE_REFLECTOR);
            this.setParentContext(this.sessionContext);
        }
    }
}

