/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.context.contexts;

import java.util.Arrays;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.context.Context;
import net.sf.morph.context.ContextException;
import net.sf.morph.context.HierarchicalContext;
import net.sf.morph.context.contexts.BaseContext;
import net.sf.morph.util.ContainerUtils;

public abstract class BaseHierarchicalContext
extends BaseContext
implements HierarchicalContext {
    private Context parentContext;

    public BaseHierarchicalContext() {
    }

    public BaseHierarchicalContext(Context parentContext) {
        this.parentContext = parentContext;
    }

    protected abstract Object getHierarchicalImpl(String var1) throws Exception;

    protected abstract String[] getPropertyNamesHierarchicalImpl() throws Exception;

    protected abstract void setHierarchicalImpl(String var1, Object var2) throws Exception;

    protected final Object getImpl(String propertyName) throws Exception {
        Context parent;
        Object value;
        block4: {
            value = null;
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("Getting property '" + propertyName + "' from context " + this.getClass().getName()));
            }
            try {
                value = this.getHierarchicalImpl(propertyName);
            }
            catch (ContextException e) {
                if (!this.getLog().isDebugEnabled()) break block4;
                this.getLog().debug((Object)("Unable to retrieve property '" + propertyName + "' from context " + this.getClass().getName() + "; attempting to read property from parent context"));
            }
        }
        if (value == null && (parent = this.getParentContext()) != null) {
            value = parent.get(propertyName);
        }
        return value;
    }

    protected final String[] getPropertyNamesImpl() throws Exception {
        String[] currentPropertyNames = this.getPropertyNamesHierarchicalImpl();
        int size = currentPropertyNames == null ? 0 : currentPropertyNames.length;
        Set propertyNames = ContainerUtils.createOrderedSet();
        if (!ObjectUtils.isEmpty((Object)currentPropertyNames)) {
            propertyNames.addAll(Arrays.asList(currentPropertyNames));
        }
        Context currentContext = this.parentContext;
        while (currentContext != null && currentContext instanceof HierarchicalContext) {
            currentPropertyNames = currentContext.getPropertyNames();
            if (!ObjectUtils.isEmpty((Object)currentPropertyNames)) {
                propertyNames.addAll(Arrays.asList(currentPropertyNames));
            }
            currentContext = ((HierarchicalContext)currentContext).getParentContext();
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    protected final void setImpl(String propertyName, Object propertyValue) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Setting property '" + propertyName + "' to value " + ObjectUtils.getObjectDescription((Object)propertyValue) + " for context " + ObjectUtils.getObjectDescription((Object)this)));
        }
        try {
            this.setHierarchicalImpl(propertyName, propertyValue);
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Unable to retrieve property '" + propertyName + "' from context " + ObjectUtils.getObjectDescription((Object)this) + "; attempting to read property from parent context"));
            }
            if (this.getParentContext() == null) {
                throw e;
            }
            this.getParentContext().set(propertyName, propertyValue);
        }
    }

    public void setParentContext(Context parentContext) {
        this.parentContext = parentContext;
    }

    public Context getParentContext() {
        return this.parentContext;
    }
}

