/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.context.contexts;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.context.Context;
import net.sf.morph.context.ContextException;
import net.sf.morph.context.DecoratedContext;
import net.sf.morph.context.support.ContextMapBridge;
import net.sf.morph.lang.Language;
import net.sf.morph.transform.Converter;
import net.sf.morph.util.ContainerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseContext
implements Context,
Map,
DecoratedContext {
    private static final ContextMapBridge DEFAULT_CONTEXT_MAP_BRIDGE = new ContextMapBridge();
    private transient Log log = LogFactory.getLog(this.getClass());
    private ContextMapBridge contextMapBridge;
    private Converter converter;
    private Language language;

    public BaseContext() {
        this.setContextMapBridge(DEFAULT_CONTEXT_MAP_BRIDGE);
        this.setConverter(Defaults.createConverter());
        this.setLanguage(Defaults.createLanguage());
    }

    protected abstract String[] getPropertyNamesImpl() throws Exception;

    protected abstract Object getImpl(String var1) throws Exception;

    protected abstract void setImpl(String var1, Object var2) throws Exception;

    public final String[] getPropertyNames() throws ContextException {
        try {
            String[] cachedPropertyNames = this.getPropertyNamesImpl();
            Set propertyNames = ContainerUtils.createOrderedSet();
            if (!ObjectUtils.isEmpty((Object)cachedPropertyNames)) {
                propertyNames.addAll(Arrays.asList(cachedPropertyNames));
            }
            Iterator iterator = propertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                if (this.getLanguage().isProperty(propertyName)) continue;
                iterator.remove();
            }
            return propertyNames.toArray(new String[propertyNames.size()]);
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to retrieve property names", e);
        }
    }

    public final Object get(String expression) throws ContextException {
        if (this.getLanguage().isProperty(expression)) {
            if (ObjectUtils.isEmpty((Object)expression)) {
                throw new ContextException("You must specify a propertyName to retrieve");
            }
            Object[] propertyNames = this.getPropertyNames();
            if (!ContainerUtils.contains(propertyNames, (Object)expression)) {
                return null;
            }
            try {
                return this.getImpl(expression);
            }
            catch (ContextException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContextException("Could not retrieve property '" + expression + "' from this context", e);
            }
        }
        return this.getLanguage().get(this, expression);
    }

    public final void set(String expression, Object value) throws ContextException {
        if (this.getLanguage().isProperty(expression)) {
            if (ObjectUtils.isEmpty((Object)expression)) {
                throw new ContextException("You must specify an expression to set");
            }
            try {
                this.setImpl(expression, value);
            }
            catch (ContextException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContextException("Could not set property '" + expression + "' in context " + ObjectUtils.getObjectDescription((Object)this), e);
            }
        } else {
            this.getLanguage().set(this, expression, value);
        }
    }

    public final Object get(String expression, Class destinationClass) throws ContextException {
        return this.get(expression, destinationClass, Locale.getDefault());
    }

    public final Object get(String expression, Class destinationClass, Locale locale) throws ContextException {
        try {
            Object object = this.get(expression);
            return this.getConverter().convert(destinationClass, object, locale);
        }
        catch (Exception e) {
            throw new ContextException("Unable to retrieve value for expression '" + expression + "' as destination " + ObjectUtils.getObjectDescription((Object)destinationClass), e);
        }
    }

    public final Object get(String expression, Locale locale, Class destinationClass) throws ContextException {
        return this.get(expression, destinationClass, locale);
    }

    public final void set(String expression, Object value, Locale locale) throws ContextException {
        if (ObjectUtils.isEmpty((Object)expression)) {
            throw new ContextException("You must specify a propertyName to set");
        }
        try {
            this.setImpl(expression, value);
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Could not set '" + expression + "' to " + ObjectUtils.getObjectDescription((Object)value), e);
        }
    }

    public void clear() {
        this.getContextMapBridge().clear(this);
    }

    public boolean containsKey(Object key) {
        return this.getContextMapBridge().containsKey(this, key);
    }

    public boolean containsValue(Object value) {
        return this.getContextMapBridge().containsValue(this, value);
    }

    public Set entrySet() {
        return this.getContextMapBridge().entrySet(this);
    }

    public Object get(Object key) {
        return this.getContextMapBridge().get(this, key);
    }

    public boolean isEmpty() {
        return this.getContextMapBridge().isEmpty(this);
    }

    public Set keySet() {
        return this.getContextMapBridge().keySet(this);
    }

    public Object put(Object key, Object value) {
        return this.getContextMapBridge().put(this, key, value);
    }

    public void putAll(Map t) {
        this.getContextMapBridge().putAll(this, t);
    }

    public Object remove(Object key) {
        return this.getContextMapBridge().remove(this, key);
    }

    public int size() {
        return this.getContextMapBridge().size(this);
    }

    public Collection values() {
        return this.getContextMapBridge().values(this);
    }

    public Converter getConverter() {
        if (this.converter == null) {
            this.setConverter(Defaults.createConverter());
        }
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Language getLanguage() {
        if (this.language == null) {
            this.setLanguage(Defaults.createLanguage());
        }
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setContextMapBridge(ContextMapBridge contextMapBridge) {
        this.contextMapBridge = contextMapBridge;
    }

    public ContextMapBridge getContextMapBridge() {
        return this.contextMapBridge == null ? DEFAULT_CONTEXT_MAP_BRIDGE : this.contextMapBridge;
    }

    protected Log getLog() {
        return this.log;
    }

    protected void setLog(Log log) {
        this.log = log;
    }
}

