---
id: try-ubuntu-before-you-install
summary: Test out and use the wonderful Ubuntu desktop without installing anything on your hardware.
categories: desktop
tags: tutorial,installation,live usb,ubuntu,desktop
difficulty: 2
status: published
published: 2017-07-24
author: Canonical Web Team <webteam@canonical.com>
feedback_url: https://github.com/canonical-websites/tutorials.ubuntu.com/issues

---

# Try Ubuntu before you install it

## Getting started
Duration: 0:01

Running Ubuntu directly from either a USB stick or a DVD is a quick and easy way to experience how Ubuntu works for you, and how it works with your hardware. Most importantly, it doesn't alter your computer's configuration in any way, and a simple restart without the USB stick or DVD is all that's needed to restore your machine to its previous state.

With a *live* Ubuntu, you can do almost anything you can from an *installed* Ubuntu:

- Safely browse the internet without storing any history or cookie data
- Access files and edit files stored on your computer or USB stick
- Create new office suite documents and save them remotely
- Fix broken configurations to get a computer running again

### Requirements

All you need is either a USB stick or DVD with Ubuntu pre-installed. For instructions on how to create these, take a look at one of the following tutorials:

- Create a bootable USB stick on [Windows][usbwindows], [Ubuntu][usbubuntu] or [macOS][usbmacos]
- Burn a DVD on [Windows][dvdwindows], [Ubuntu][dvdubuntu] or [macOS][dvdmacos]

![screenshot](https://assets.ubuntu.com/v1/0e7183ed-desktop-overview-complete.jpg)

## Boot from DVD
Duration: 0:01

It's easy to boot Ubuntu from a DVD. Here’s what you need to do:

1. Put the Ubuntu DVD into your optical/DVD drive.
1. Restart your computer.

A few moments later you'll see the language selection menu followed by Ubuntu's boot options. Select the top entry, **Try Ubuntu without installing**, and press return.

If you don’t get this menu, take a look at the [community DVD guide][dvdguide] for help.

![screenshot](https://assets.ubuntu.com/v1/12c3e81a-ubuntu-try.png)

## Boot from USB flash drive
Duration: 0:02

Most computers will boot from USB automatically:

1. Insert the USB flash drive
1. Restart your computer

You should see the same language selection menu and boot options we saw in the previous 'Boot from DVD' step. Select the top entry, **Try Ubuntu without installing**, and press return.

If your computer doesn't automatically boot from USB, try holding `F12` when your computer first starts. With most machines, this will allow you to select the USB device from a system-specific boot menu.

positive
: F12 is the most common key for bringing up your system's boot menu, but both Escape and F2 are typical alternatives. If you're unsure, look for a brief message when your system starts - this will often inform you of which key to press to bring up the boot menu.

## Choose your preferred language
Duration: 0:03

After the desktop has loaded, you'll see the welcome window. From here, you can select your language from a list on the left and choose between either installing Ubuntu directly, or trying the desktop first. Select **Try Ubuntu** to launch into the full desktop experience.

![screenshot](https://assets.ubuntu.com/v1/49a92ce6-install_1.jpg)

## Enjoy Ubuntu
Duration: 0:01

Your *live* desktop will appear. Have a look around, check out the [new features][ubuntufeatures], and enjoy the simplicity of Ubuntu's intuitive interface.

You can still choose to install Ubuntu after passing the Welcome pane by clicking on the **Install Ubuntu** icon on the desktop background.

![screenshot](https://assets.ubuntu.com/v1/4688006c-try-ubuntu-16-04.jpg)

### Finding help

Finally, if you get stuck, help is always at hand:

* [Ask Ubuntu][askubuntu]
* [Ubuntu Forums][ubuntuforums]
* [IRC-based support][ircsupport]

<!-- LINKS -->
[usbmacos]: https://tutorials.ubuntu.com/tutorial/tutorial-create-a-usb-stick-on-macos
[usbwindows]: https://tutorials.ubuntu.com/tutorial/tutorial-create-a-usb-stick-on-windows
[usbubuntu]: https://tutorials.ubuntu.com/tutorial/tutorial-create-a-usb-stick-on-ubuntu
[dvdmacos]: https://tutorials.ubuntu.com/tutorial/tutorial-burn-a-dvd-on-macos
[dvdwindows]: https://tutorials.ubuntu.com/tutorial/tutorial-burn-a-dvd-on-windows
[dvdubuntu]: https://tutorials.ubuntu.com/tutorial/tutorial-burn-a-dvd-on-ubuntu
[dvdguide]: https://help.ubuntu.com/community/BootFromCD
[askubuntu]: https://askubuntu.com/
[ubuntuforums]: https://ubuntuforums.org/
[ircsupport]: https://wiki.ubuntu.com/IRC/ChannelList
[ubuntufeatures]: https://www.ubuntu.com/desktop/features
