---
id: tutorial-install-ubuntu-desktop-1604
summary: Install Ubuntu 16.04 (Xenial) onto your laptop or PC computer, from either a DVD or a USB flash drive.
categories: desktop
tags: tutorial,installation,ubuntu,desktop,Ubuntu 16.04 LTS
difficulty: 2
status: published
published: 2018-04-18
author: Canonical Web Team <webteam@canonical.com>
feedback_url: https://github.com/canonical-websites/tutorials.ubuntu.com/issues

---

# Install Ubuntu 16.04 desktop

## Overview
Duration: 0:05

negative
: This tutorial covers the installation of a previous *Long Term Support* release (Ubuntu 16.04 LTS). Jump to [Install Ubuntu 18.04 desktop](https://tutorials.ubuntu.com/tutorial/tutorial-install-ubuntu-desktop) if you wish to install the latest version. 

The Ubuntu desktop is easy to use, easy to install and includes everything you need to run your organisation, school, home or enterprise. It's also open source, secure, accessible and free to download.

![screenshot](https://assets.ubuntu.com/v1/8de0a986-ubuntu-desktop.png)

In this tutorial, we're going to install Ubuntu desktop onto your computer, using either your computer's DVD drive or a USB flash drive.

## Requirements
Duration: 0:01

You'll need to consider the following before starting the installation:

* Connect your laptop to a power source.
* Ensure you have at least 5GB of free storage space.
* Have access to either a DVD or a USB flash drive containing the version of Ubuntu you want
  to install.
* Make sure you have a recent backup of your data. While it's unlikely that
  anything will go wrong, you can never be too prepared.

See [Installation/System Requirements](https://help.ubuntu.com/community/Installation/SystemRequirements) for more specific details on hardware requirements. We also have [several tutorials](/) that explain how to create an Ubuntu DVD or USB flash drive.

## Boot from DVD
Duration: 0:03

It’s easy to install Ubuntu from a DVD. Here’s what you need to do:

1. Put the Ubuntu DVD into your optical/DVD drive.
1. Restart your computer.

A few moments later, after the desktop has loaded, you'll see the welcome window. From here, you can select your language from a list on the left and choose between either installing Ubuntu directly, or trying the desktop first (if you like what you see, you can also install Ubuntu from this mode too).

![screenshot](https://assets.ubuntu.com/v1/dfc572f0-download-desktop-install-ubuntu-desktop_1.jpg)

If you don’t get this menu, read the [booting from the DVD guide](https://help.ubuntu.com/community/BootFromCD?_ga=2.102380610.2115462233.1496186978-1155966827.1485186360) for more information.

## Boot from USB flash drive
Duration: 0:02

Most computers will boot from USB automatically. Simply insert the USB flash drive and either power on your computer or restart it. You should see the same welcome window we saw in the previous 'Install from DVD' step, prompting you to choose your language and either install or try the Ubuntu desktop.

If your computer doesn't automatically boot from USB, try holding `F12` when your computer first starts. With most machines, this will allow you to select the USB device from a system-specific boot menu.

positive
: F12 is the most common key for bringing up your system's boot menu, but Escape, F2 and F10 are common alternatives. If you're unsure, look for a brief message when your system starts - this will often inform you of which key to press to bring up the boot menu.

## Prepare to install Ubuntu
Duration: 0:01

After choosing to install Ubuntu from the welcome window, you will be asked about updates and third-party software.

- We advise enabling both `Download updates` and `Install third-party software`.
- Stay connected to the internet so you can get the latest updates while you install Ubuntu.
- If you are not connected to the internet, you will be asked to select a wireless network, if available. We advise you to connect during the installation so we can ensure your machine is up to date

![screenshot](https://assets.ubuntu.com/v1/3bbb0e35-download-desktop-install-ubuntu-desktop_2.jpg)

## Allocate drive space
Duration: 0:01

Use the checkboxes to choose whether you’d like to Install Ubuntu alongside another operating system, delete your existing operating system and replace it with Ubuntu, or — if you’re an advanced user — choose the ’**Something else**’ option.

![screenshot](https://assets.ubuntu.com/v1/e07b98b8-ubuntu-installation-type.png)

positive
: Ubuntu needs about 4.5 GB of space for a minimal installation. But you'll obviously need space for your own data and any extra applications you install.

## Begin installation
Duration: 0:01

After configuring storage, click on the 'Install Now' button. A small pane will appear with an overview of the storage options you've chosen, with the chance to go back if the details are incorrect.

Click `Continue` to fix those changes in place and start the installation process.

![screenshot](https://assets.ubuntu.com/v1/a76b68ce-ubuntu-verify-install.png)

## Select your location
Duration: 0:01

If you are connected to the internet, your location will be detected automatically. Check your location is correct and click ’Forward’ to proceed.

If you’re unsure of your time zone, type the name of a local town or city or use the map to select your location.

![screenshot](https://assets.ubuntu.com/v1/a942aa3d-download-desktop-install-ubuntu-desktop_6.jpg)

positive
: If you’re having problems connecting to the Internet, use the menu in the top-right-hand corner to select a network.

## Select your preferred keyboard layout
Duration: 0:01

To tell Ubuntu the layout of your keyboard, click on the language option you need followed by your keyboard's specific layout. If you’re not sure, click the ’**Detect Keyboard Layout**’ button for help.

Keyboard layouts can always be changed, and supplementary layouts added, from the desktop after installation.

![screenshot](https://assets.ubuntu.com/v1/310b5196-download-desktop-install-ubuntu-desktop_7.jpg)

## Login details
Duration: 0:01

Enter your name and the installer will automatically suggest a computer name and username. These can easily be changed if you prefer. The computer name is how your computer will appear on the network, while your username will be your login and account name.

Next, enter a strong password. The installer will let you know if it's too weak.

You can also choose to enable automatic login and home folder encryption. If your machine is portable, we recommend keeping automatic login disabled and enabling encryption. This should stop people accessing your personal files if the machine is lost or stolen.

![screenshot](https://assets.ubuntu.com/v1/69d32ea7-download-desktop-install-ubuntu-desktop_8.jpg)

: If you enable home folder encryption and you forget your password, you won't be able to retrieve any personal data stored in your home folder.

## Background installation
Duration: 0:20

The installer will now complete in the background while the installation window teaches you a little about how awesome Ubuntu is. Depending on the speed of your machine and network connection, installation should only take a few minutes.

![screenshot](https://assets.ubuntu.com/v1/4e133117-download-desktop-install-ubuntu-desktop_9.jpg)

## Installation complete
Duration: 0:01

After everything has been installed and configured, a small window will appear asking you to restart your machine. Click on `Restart Now` and remove either the DVD or USB flash drive when prompted.

![screenshot](https://assets.ubuntu.com/v1/f4e2a592-download-desktop-install-ubuntu-desktop_10.jpg)

Congratulations! You have successfully installed the world's most popular Linux operating system!

It's now time to start enjoying Ubuntu!

### Finding help

If you get stuck, help is always at hand.

* [Ask Ubuntu](https://askubuntu.com/)
* [Ubuntu Forums](https://ubuntuforums.org/)
* [IRC-based support](https://wiki.ubuntu.com/IRC/ChannelList)
