---
wrapper_template: "legal/_base_legal_markdown.html"
context:
  title: "Canonical Support Portal - Terms of Service"
  description: "Ubuntu and Canonical Legal - Canonical Support Portal Terms of Service"
  update_date: "Version - December 2023"
  copydoc: https://docs.google.com/document/d/1ugZ-7R6qSYSKjofiPicy444c5zXho81J3Z_f-hpCcZc/edit
---

# Canonical Support Portal - Terms of Service

These Terms of Service cover your ("**you**" or "**your**") use of the Canonical Support Portal (the “**Portal**”) provided by Canonical Group Limited ("**Canonical**", "**us**", "**our**" or "**we**") subject to and in accordance with these Terms of Service.

Please read these Terms of Service carefully before you use the Portal. By using the Portal, you agree to become bound by these Terms of Service. You may not use the Portal for illegal or unauthorised purposes or otherwise not in accordance with these Terms of Service.

If you are entering into these Terms of Service on behalf of a company or legal entity, you represent that you have authority to bind such company or legal entity, its officers, employees and agents and all users who access the Portal, to these Terms of Service. “you” and “your” shall refer to the company or legal entity and such users. If you do not have such authority do not accept these Terms of Service.

Any change or update to the Portal or Terms of Service will be made in accordance with section 4 below.

## 1. Canonical Support Portal

The Portal is a self-serve, web-based customer service tool. It enables you, as a Canonical customer representative, to find information, request support and resolve issues autonomously. Canonical customers with active assets can:

- manage their support requests;
- read knowledge base articles;
- find phone numbers for sales and support; and
- view their assets.

## 2. Account

You will need to register for an Ubuntu One account and subsequently use Single Sign On (SSO) to access and use the Portal. SSO is an identity provider service that creates, maintains and manages user identity information, providing authentication services for Canonical and other third party applications. An Ubuntu One account is the single account you use to log in to certain services and sites related to <a href="https://www.ubuntu.com">www.ubuntu.com</a>. We reserve the right to reject your request for an SSO and Ubuntu One account or to immediately cancel or suspend your SSO and Ubuntu One account and your use of the Portal at any time if you do not comply with the following requirements. You must not attempt to create an SSO and Ubuntu One account or use the Portal if doing so would violate these Terms of Service. You must:

- have an Ubuntu One account and log in through SSO;
- not use the Portal for illegal or unauthorised purposes (or which encourage or permit illegal or authorised purposes), in infringement of a third party's’ rights or otherwise in accordance with these Terms of Service;
- not take any action or use the Portal in any way that might bring Canonical into disrepute or affect the ability of Canonical to provide the Portal;
- not use the Portal in any manner that might be libellous or defamatory, that contains threats or incites violence towards individuals or entities, or that violates the privacy rights of any third party.

If you do not have an Ubuntu One account you will need to create this. You are responsible for choosing an appropriate password for your account and for keeping such password secure. Canonical will not ask you for your password and you should not reveal it to anyone. You are responsible for keeping your account details up to date.

You may request deletion of any data held in the Portal at any time by emailing <a href="mailto:support@canonical.com">support@canonical.com</a>. Note that this does not delete your Ubuntu One account, since you might be using it for other Canonical services. To delete your Ubuntu One account, visit <a href="https://login.ubuntu.com/">https://login.ubuntu.com/</a> and click **Permanently delete account**.

## 3. Changes and termination

We continually aim to improve the delivery and content of the Portal and accordingly may make changes to the Portal from time to time.

New features may be added, but we may also modify or discontinue (temporarily or permanently) part of the Portal, in part or in whole.

In the event of a material change to the Portal, we will notify you via the email you have provided to us. What constitutes a material change in this circumstance will be determined by Canonical, in good faith and using common sense and reasonable judgment.

Similarly, we may occasionally make changes to these Terms of Service. If Canonical does make changes to these Terms of Service, all changes will go into effect at the time we post the updated Terms of Service or as otherwise notified at that time.

## 4. Intellectual property and content

### Intellectual property

You have a non-exclusive, non-transferable (to the extent permitted by law) right to view, access and use the Portal for such time as it is made available by us strictly in accordance with these Terms of Service.

You will not acquire any rights to the Portal (or the intellectual property rights contained therein) from your use of the Portal, other than as set out in these Terms of Service.

### Canonical materials

All materials contained within the Portal are copyright of Canonical. All content provided by you or a third party are accessed at your sole discretion and risk.

### Third party content

You may use and access content provided by third parties in your use of the Portal.

Canonical is not responsible for any content provided by any third party. Should you reasonably believe that any third party content you access through the Service is in breach of any law, regulation or third party's rights, you should notify Canonical in writing at the address below. In doing so, please: (a) identify the material which you believe to be infringing; (b) identify what you believe this material infringes and why; (c) Provide your name, email address, address and telephone number; (d) confirm that you believe in good faith that this material is infringing a law or third party's rights and that, to the best of your knowledge, the information you are providing is correct; (e) identify if you are acting on behalf of the third party whose rights may have been infringed; and (f) provide your physical or electronic signature.

### Licence

To the extent that the Portal is not provided to you under an open source licence, Canonical grants to you a world-wide, non-exclusive, non-transferable licence for so long as we provide access to the Portal, to use Canonical’s intellectual property rights in the Portal (“**Licensed IP**”) in accordance with these Terms of Service. You may not use, copy, modify, disassemble, decompile, reverse engineer, or distribute the Licensed IP except as expressly permitted in these Terms of Service, or permit access to the Licensed IP to any third party other than those acting on your behalf except as expressly permitted in these Terms of Service.

## 5. Personal data

In order to access and use the Portal, you will be required to provide information about yourself such as your name and email address, as well as optional information such, timezone, country, IP address and related information. Any such information you provide to Canonical must always be accurate, correct and up to date. We may also ask you to participate in Portal related surveys, for feedback purposes. Participating in surveys is optional.

Our <a href="/legal/data-privacy">Privacy Policy</a> and <a href="/legal/data-privacy/support-portal">Support Portal Privacy Notice</a> explain how we treat your personal data and protect your privacy when using our services. Canonical may need to provide limited personal data, such as your name and email address, to third parties for the purposes of providing you with access to the Portal. By accessing and using the Portal you are agreeing to the use of your personal data in this way.

We may also collect certain non-personally-identifiable information, which is located on your computer. The information collected may include statistics relating to how often data is transferred, and performance metrics in relation to software and configuration. You agree this information may be retained and used by Canonical.

Canonical may disclose any or all personal data and contents you have sent, posted or published if required to comply with applicable law or the order or requirement of a court, administrative agency or other governmental body. All other use of your personal data is subject to the Privacy Policy and applicable Privacy Notice.

## 6. Liability

Your use of the Portal is at your sole risk. The Portal is provided on an “as is” and “as available” basis without warranty of any kind, other than as expressly set out in these Terms of Service. All warranties (whether express, implied, statutory or otherwise) in respect of the Portal are expressly excluded to the maximum extent permitted by law.

Canonical will provide the Portal with reasonable care and skill, and Canonical will use reasonable efforts to ensure the availability of the Portal, but makes no guarantee that the Portal will be available without interruption or will be error-free.

In the case of third party content, you acknowledge that such content is provided to you by the relevant third party pursuant to the relevant terms and conditions and Canonical will have no liability whatsoever in contract, tort or otherwise to you in respect of such content.

Canonical will not be liable in contract, tort or otherwise for any: indirect or consequential loss; loss of profits; loss of revenue; loss of anticipated savings; loss of business or business opportunity; loss of goodwill; or loss of or corruption to data. Otherwise, Canonical’s total liability in contract, tort or otherwise for any claims is limited to £100.

Nothing in these Terms of Service will exclude or limit Canonical’s liability for: death or personal injury caused by the negligence of Canonical; fraud or fraudulent misrepresentation; or any other liability that cannot be excluded or limited by law.

## 7. General

These Terms of Service are governed by the laws of England and any dispute will be heard by the courts in England.

Failure by Canonical to enforce any right or provision of these Terms of Service shall not constitute a waiver of such right or provision. If any part of these Terms of Service is held invalid or unenforceable, that part will be construed to reflect the parties original intent, and the remaining portions will remain in full force and effect. The terms of these Terms of Service do not affect your statutory rights.

Any notices should be sent by registered post to:

<div style="margin: 2rem;">
  <p>
    Canonical Group Limited,<br />
    St Dunstans House<br />
    4th floor, 201 Borough High St<br />
    London SE1 1JA<br />
    United Kingdom<br />
  </p>
</div>
