---
wrapper_template: "legal/modern-slavery-statement/_base_markdown.html"
context:
  title: "Modern Slavery Statement"
  description: "Ubuntu and Canonical Legal - Modern Slavery Statement"
  copydoc: https://assets.ubuntu.com/v1/f88a728b-Executed%20Modern%20Slavery%20Statement%20-%202024.pdf
---

# Modern Slavery Statement - 2024

## What is modern slavery?

Modern slavery is the illegal exploitation of people for personal or commercial gain, often in horrendous conditions which the victim cannot escape. It includes human trafficking.

This statement sets out the steps Canonical has taken during its financial year to ensure that slavery and human trafficking is not taking place in its supply chain.

## Who we are - our structure and supply chains

Canonical serves as the publisher for the Ubuntu open source operating system within the information technology sector. The company is dedicated to making open source software accessible to a global audience. In addition to this mission, Canonical provides services such as software development and support.

Canonical, together with its affiliated entities, maintains a global workforce exceeding 1000 personnel, strategically located in five offices around the world.

As an organisation Canonical’s internal activities include engineering, support, project management and commercial operation services - legal, finance, HR and sales and business operations.

Canonical procures services from a number of external third parties to support its activities and services.

Canonical Group Limited and Canonical UK Limited are English subsidiaries of Canonical Limited and a number of affiliated entities provide services. A full list of Canonical entities can be found at [https://www.ubuntu.com/legal/companies](https://www.ubuntu.com/legal/companies). This statement relates to Canonical Group Limited and Canonical UK Limited.

## Our Policy

Canonical does not tolerate modern slavery. The company will not knowingly establish associations with customers, suppliers, personnel, or other business partners involved in any form of forced labour or human trafficking.

Canonical, in strict adherence to the Modern Slavery Act 2015, imposes a duty on itself and its supply chain to ensure compliance with anti-modern slavery regulations.

To safeguard against modern slavery, Canonical has implemented a comprehensive set of procedures within its business and supply chain.

Recognising the intricate nature of modern slavery as a supply chain concern, Canonical collaborates closely with its suppliers. The company conducts periodic reviews of all policies and procedures, consistently striving to enhance its approach. Ongoing evaluations of procurement processes and supplier engagements remain integral to Canonical's commitment to combat modern slavery.

## Our Due Diligence Processes

Canonical employs a comprehensive approach to due diligence in identifying and mitigating the risks of modern slavery:

1. Risk Assessment: Canonical conducts regular risk assessments, considering the nature of its industry, geographic locations, and types of labour involved in its supply chains. This dynamic assessment informs the development of targeted risk mitigation strategies.
2. Supplier Engagement: Canonical actively engages with suppliers to assess their commitment to eradicating modern slavery. The company incorporates clauses within contracts requiring compliance with modern slavery legislation and adherence to ethical labour practices.
3. Audits and Inspections: Canonical conducts audits and inspections of its suppliers to assess their compliance with the Anti-Slavery Policy. These assessments are conducted by qualified personnel to ensure a thorough and accurate evaluation of adherence to ethical standards.
4. Training and Awareness: Canonical invests in ongoing training programs for personnel and suppliers to raise awareness of modern slavery risks, identification, and reporting mechanisms. These initiatives empower individuals to actively contribute to the prevention and detection of modern slavery.

## Our Reporting Mechanisms

Canonical has established reporting mechanisms to encourage the reporting of any concerns or suspicions related to modern slavery. Canonical is dedicated to fostering an environment that encourages openness and transparency, empowering all stakeholders to contribute to the eradication of modern slavery from our operations and supply chain.

## Our Effectiveness and Continuous Improvement

Canonical is committed to the ongoing improvement of its efforts to combat modern slavery. The company regularly reviews and updates its policies, procedures, and due diligence processes to adapt to emerging risks and incorporate best practices. Canonical actively seeks feedback from stakeholders to enhance its approach to ethical sourcing continually.

## Further actions and sign-off

Following our review of our actions this financial year, ending 31st December 2023, to prevent slavery or human trafficking from occurring in our business or supply chains, we intend to take the following further steps to tackle slavery and human trafficking:

- We are committed to enhancing our reporting mechanisms by developing and implementing a whistleblowing tool that allows individuals to anonymously report any concerns or suspicions related to slavery or human trafficking. This tool will facilitate a secure and confidential platform for reporting, ensuring that information is promptly received and appropriately addressed.

- Recognising the importance of responsible sourcing, we will enhance the screening process for our suppliers, with a specific focus on those operating in regions identified as at-risk for slavery and human trafficking. This screening will involve assessments of suppliers' compliance with anti-slavery regulations, ethical labour practices, and adherence to our established standards.

- We will strengthen our internal training programs to ensure that personnel, particularly those involved in procurement and supply chain management, are well-informed about the risks and indicators of slavery and human trafficking. This training will empower our workforce to identify, prevent, and address potential issues effectively.


This statement is made in accordance with section 54(1) of the Modern Slavery Act 2015 and constitutes Canonical’s slavery and human trafficking statement for the financial year ending 31st December 2023.

This statement was approved by the director of Canonical Group Limited and Canonical UK Limited.

**Neil French**<br />
**Canonical**<br />
**21st February 2024**

<div class="p-top">
  <a href="#" class="p-top__link">Back to top</a>
</div>
