---
wrapper_template: "legal/_base_legal_markdown.html"
context:
  title: "Privacy notice – Partner Portal"
  description: This privacy notice tells you about the information we collect from you when you access the Canonical Partner Portal.
  update_date: "Version - January 2024"
  copydoc: https://docs.google.com/document/d/1yuh7dL3jjkj21sKJCUhm_z00PKzH4vssY339wbp4U-s/edit
---

# Privacy notice - Partner Portal

This privacy notice tells you about the information we collect from you when you access the Canonical Partner Portal. In collecting this information, we are acting as a data controller and, by law, we are required to provide you with information about us, about why and how we use your data, and about the rights you have over your data. For more information, please see our [privacy policy](/legal/dataprivacy).

## Who are we ?

We are Canonical Group Limited. Our address is 5 New Street Square, London, EC4A 3TW, United Kingdom. You can contact us by post at the address set out in the “right to complain” section, below or by email to [dataprotection@canonical.com](mailto:dataprotection@canonical.com) for the attention of "Legal".

We are not required to have a data protection officer, so any enquiries about our use of your personal data should be addressed to the contact details above.

## What personal data do we collect?

When you access the Canonical Partner Portal, we ask you to submit your USERID and password. You will be asked for further information through the deal registration system, including name, address, contact telephone number, email address and information about the deal you are registering.

## Why do we collect this information?

Your information will be used to identify you as a partner of Canonical and to enable you to submit information for deal registration.

We require this information in order to provide you with access to the Canonical Partner Portal, to operate the Canonical Partner Portal and to register deals with Canonical.

## What do we do with your information?

We may:

- process your details in order to ensure that you are a partner of Canonical able to use the Canonical Partner Platform;
- contact you in response to information provided on the Canonical Partner Platform;
- contact you to provide or obtain any other pertinent information concerning the Canonical Partner Platform;
- monitor and analyse usage of the Canonical Partner Platform, including by analysing and creating reports about the Canonical Partner Platform;
- provide reports to third party suppliers about the use of the Canonical Partner Platform; and
- contact you by email about our products and services, if you have consented to receiving them. If you are a business customer, we may contact you by telephone and email from time to time to discuss products and services that we offer.

Your information is stored in our order processing system and may be processed outside of the European Economic Area. It is shared with the third parties set out below and as reasonably required for Canonical to process and store your data.

The Canonical Partner Platform is hosted by a third party supplier, Zift Solutions. In order for the Canonical Partner Platform to operate we share your information with this third party supplier and they may share information about you with us.

## Our legal basis to use your Personal information

### Our legitimate business interests

In using the Canonical Partner Platform our Partner Portal terms and conditions will apply as well as the terms of your contract with Canonical. Our legal basis for using your personal information is that it is necessary for our legitimate interest in providing the Canonical Partner Platform in accordance with the Partner Portal terms and conditions between us and the business you are associated with.

In using the Canonical Partner Platform our legal basis for processing your personal information is that it is necessary for our legitimate interests in conducting our business and meeting the requirements of you, our current and prospective partners and customers.

We may contact you from time to time with information about products and services that we offer (see [Marketing Communications to Businesses](#mkt-comms)). Our legal basis for using your personal information to contact you is that it is necessary for our legitimate interest in keeping you informed of the products and services that we offer. You can opt out of marketing communications as set out below.

## Your consent

If you create an account on the Canonical Partner Platform, you will have the option to provide your consent to us sending you information about the products and services that we offer (see [Email Marketing Communications](#mkt-comms)). You can withdraw your consent at any time.

## How long do we keep your information for?

We keep your order information for so long as reasonably required in accordance with our record retention policy. Your personal information associated with the order will then be removed.

## Your rights over your information

- You have a number of important rights under data protection laws free of charge. In summary, those include rights to:
- fair processing of information and transparency over how we use your use personal information;
- access to your personal information and to certain other supplementary information that this Privacy notice is already designed to address;
- require us to correct any mistakes in your information which we hold;
- require the erasure of personal information concerning you in certain situations;
- receive the personal information concerning you which you have provided to us, in a structured, commonly used and machine-readable format and have the right to transmit those data to a third party in certain situations;
- object at any time to processing of personal information concerning you for direct marketing;
- object to decisions being taken by automated means which produce legal effects concerning you or similarly significantly affect you;
- object in certain other situations to our continued processing of your personal information;
- otherwise restrict our processing of your personal information in certain circumstances; and claim compensation for damages caused by our breach of any data protection laws.

For further information on each of those rights, including the circumstances in which they apply, see the Guidance from the UK Information Commissioner's Office (ICO) on individuals rights under the General Data Protection Regulation.

If you would like to exercise any of those rights, please:

- email, call or write to us, please see "Your right to complain" section,
- let us have enough information to identify you,
- let us have proof of your identity and address (a copy of your driving licence or passport and a recent utility or credit card bill), and
- let us know the information to which your request relates.

If you would like to unsubscribe from any email you can also click on the 'unsubscribe' button at the bottom of the email. Please note that this is not automatic, but will be implemented once confirmed.

By law, you can ask us what information we hold about you, and you can ask us to correct it if it is inaccurate.

You can also ask us to give you a copy of the information and to stop using your information for a period of time if you believe we are not doing so lawfully.

To submit a request by email, post or telephone, please use the contact information provided above.

<h2 id="mkt-comms">Email marketing communications</h2>

Canonical offers a free email newsletter subscription service to keep you informed of our products and services. You may receive these marketing communications from us. We incorporate a tracking system in our email marketing communications which allows us to monitor whether the email has been opened and which links are the most popular. This allows us to tailor and refine our service. to ensure that the emails you receive are relevant to your interests.

Where you have consented to receiving email marketing material from us or are currently receiving material relating to similar products or services, you may at any time ask us to cease sending you such material by clicking the unsubscribe button at the end of the email or by sending an email to [dataprotection@canonical.com](mailto:dataprotection@canonical.com) with the heading "unsubscribe" or you can go to your subscription centre page (you will be asked to insert the email address you receive the marketing communications on) and click the 'unsubscribe' link at the foot of the page as appropriate. Unsubscribe instructions are also clearly outlined at the bottom of every direct marketing email that we send you.

## Links to other websites

The Canonical Partner Portal may contain links to other third party websites with whom we have a relationship. However, we are not responsible for these websites and their privacy practices. We therefore suggest that you read the privacy policy statements on any website that you visit from a link on this site, as their policies and procedures may differ from our own.

## Retention of Personal Information

The period for which we will retain personal information will vary depending on the purposes that it was collected for, as well as the requirements of any applicable law or regulation:

- if you have signed up for an account on the Canonical Partner Platform, we will store your personal information and the information in your account for as long as is necessary to provide the account, and for the period for which you or we could bring legal proceedings in relation to the running of your account;
- if you enter into a customer contract through the Canonical Partner Platform, we will store your personal information and information about your order for as long as is necessary to comply with applicable tax legislation, and for the period for which you or we could bring legal proceedings in relation to your order.

## Keeping your personal information secure

We have appropriate security measures in place to prevent personal information from being accidentally lost, or used or accessed in an unauthorised way. We limit access to your personal information to those who have a genuine business need to know it. Those processing your information will do so only in an authorised manner and are subject to a duty of confidentiality.

We also have procedures in place to deal with any suspected data security breach. We will notify you and any applicable regulator of a suspected data security breach where we are legally required to do so.

## Changes to this Privacy notice

This Privacy notice will be reviewed from time to time. If we decide to change this Privacy notice we will post the changes here. However, if we intend to make material changes to the way we use your personal information we will notify you before doing so. Any personal information held will be governed by our most current notice.

## Your right to complain

We hope that we can resolve any query or concern you raise about our use of your information. You can contact us any time. Any questions, comments and requests regarding this Privacy notice or any other related matter are welcomed and should be addressed to [dataprotection@canonical.com](mailto:dataprotection@canonical.com) or to the address below:

<div style="margin:2rem;">
Legal, Canonical<br />
4th floor, 201 Borough High St.<br />
London SE1 1JA<br />
United Kingdom<br />
</div>

Alternatively, you can use the relevant [contact us](/legal/data-privacy/enquiry) form.

If you have a complaint about our use of your information, you can contact the Information Commissioner's Office via their website at [ico.org.uk](https://ico.org.uk/make-a-complaint/) or write to them at:

<div style="margin:2rem;">
Information Commissioner's Office<br />
Wycliffe House<br />
Water Lane<br />
Wilmslow<br />
Cheshire<br />
SK9 5AF<br />
United Kingdom
</div>
