---
wrapper_template: "legal/_base_legal_markdown.html"
context:
  title: "Privacy notice – Online purchase"
  description: "This privacy notice tells you about the information we collect from you when you purchase one or more of our products via our website."
  copydoc: https://docs.google.com/document/d/1ZSNnMiLJl6SGSV0D_cr6MJAwpkf6xzbKYJdTL9MxLHc/edit
---

<h4 class="p-muted-heading">Version - July 2023</h4>
<hr style="margin-bottom: 2rem;" />

# Privacy notice - Online purchase

This privacy notice tells you about the information we collect from you when you purchase one or more of our products via our website. In collecting this information, we are acting as a data controller and, by law, we are required to provide you with information about us, about why and how we use your data, and about the rights you have over your data. For more information, please see our [privacy policy](/legal/data-privacy).

## Who are we?

We are Canonical Group Limited. Our address is 5 New Street Square, London, EC4A 3TW, United Kingdom. You can contact us by post at the address set out in the "right to complain" section, below or by email to [dataprotection@canonical.com](mailto:dataprotection@canonical.com) for the attention of "Legal".

We are not required to have a data protection officer, so any enquiries about our use of your personal data should be addressed to the contact details above.

## What personal data do we collect?

When you purchase products from us online, we ask you for your name, address, contact telephone number, email address and credit card information.

## Why do we collect this information?

Your information will be used by our third party payment provider to verify your credit card details for your purchase and for Canonical or our third party supplier to process your order and to send you your goods. We will also send you a receipt via email and we (or the third party supplier) may use your telephone number to contact you regarding your delivery.

We require this information in order to process your payment, deliver your goods and fulfil our contract with you.

## What do we do with your information?

Your information is stored in our database and may be processed outside of the European Economic Area.

Such countries do not have the same data protection laws as the United Kingdom and EEA. Where the European Commission has not given a formal decision that such countries provide an adequate level of data protection, any transfer of your personal information will be subject to approved contract terms designed to help safeguard your privacy rights and give you remedies in the unlikely event of misuse of your personal information. If you would like further information please contact us (see "Your right to complain" below). It is shared with the third parties set out below and as reasonably required for Canonical to process and store your data.

Your credit card details are passed to a third-party payment processor who retains credit card details.

Our third-party payment processor is a company called Stripe Payments Europe, Limited, who we use to process and confirm your payments. We share with them your name, address and credit card information only for payment purposes. We do not retain credit card data but our payment service providers do. For your safety, we have in place agreement between us to protect, safeguard your information and prohibit any sharing for any reasons whatsoever.

We also use a third-party supplier called Shopify Inc. to provision your order and we share with them your name, address and telephone number in order to complete the delivery.

## Our legal basis to use your Personal information

### Our legitimate business interests

Our legal basis for using your personal information is that it is necessary for our legitimate interest in providing the purchased product in accordance with the terms and conditions between us and the business you are associated with.

When purchasing a product from us online, our legal basis for processing your personal information is that it is necessary for our legitimate interests in conducting our business and meeting the requirements of you, our current and prospective customers.

We may contact you from time to time with information about products and services that we offer (see [Marketing Communications to Businesses](/legal/data-privacy/partner-portal#mkt-comms)). Our legal basis for using your personal information to contact you is that it is necessary for our legitimate interest in keeping you informed of the products and services that we offer. You can opt out of marketing communications as set out below.

### Your consent

If you purchase a product from us online, you will have the option to provide your consent to us sending you information about the products and services that we offer (see [Email Marketing Communications](/legal/data-privacy/partner-portal#mkt-comms)). You can withdraw your consent at any time.

## How long do we keep your information for?

We keep your order information for so long as reasonably required in accordance with our record retention policy. Your personal information associated with the order will then be removed.

## Your rights over your information

You have a number of important rights under data protection laws. In summary, those include rights to:

- fair processing of information and transparency over how we use your personal information;
- access to your personal information and to certain other supplementary information that this Privacy Notice is already designed to address;
- require us to correct any mistakes in your information which we hold;
- require the erasure of personal information concerning you in certain situations;
- receive the personal information concerning you which you have provided to us, in a structured, commonly used and machine-readable format and have the right to transmit that data to a third party in certain situations;
- object at any time to processing of personal information concerning you for direct marketing;
- object to decisions being taken by automated means which produce legal effects concerning you or similarly significantly affect you;
- object in certain other situations to our continued processing of your personal information;
- otherwise restrict our processing of your personal information in certain circumstances;
- claim compensation for damages caused by out breach of any data protection laws.

For further information on each of those rights, including the circumstances in which they apply, see the Guidance from the UK Information Commissioner's Office (ICO) on individuals rights.

If you would like to exercise any of those rights, please:

- email, call or write to us, please see "Your right to complain" section below;
- let us have enough information to identify you;
- let us have proof of your identity and address (a copy of your driving licence or passport and a recent utility or credit card bill); and
- let us know the information to which your request relates.

If you would like to unsubscribe from any email please see below.

By law, you can ask us what information we hold about you, and you can ask us to correct it if it is inaccurate.

You can also ask us to give you a copy of the information and to stop using your information for a period of time if you believe we are not doing so lawfully.

To submit a request by email, post or telephone, please use the contact information provided above.

## Email marketing communications

Canonical offers a free email newsletter subscription service to keep you informed of our products and services. You may receive these marketing communications from us. We incorporate a tracking system in our email marketing communications which allows us to monitor whether the email has been opened and which links are the most popular. This allows us to tailor and refine our service to ensure that the emails you receive are relevant to your interests.

Where you have consented to receiving email marketing material from us or are currently receiving material relating to similar products or services, you may at any time ask us to cease sending you such material by (i) clicking the unsubscribe button at the end of the email, (ii) reply to the email with "STOP", (iii) sending an email to [dataprotection@canonical.com](mailto:dataprotection@canonical.com), or (iv) navigating to your subscription centre page (you will need to login if you have not already done so) and click the 'unsubscribe' link at the foot of the page as appropriate.

## Links to other websites

The purchased products may contain links to other third party websites with whom we have a relationship. However, we are not responsible for these websites and their privacy practices. We therefore suggest that you read the privacy policy statements on any website that you visit from a link on this site, as their policies and procedures may differ from our own.

## Keeping your personal information secure

We have appropriate security measures in place to prevent personal information from being accidentally lost, or used or accessed in an unauthorised way. We limit access to your personal information to those who have a genuine business need to know it. Those processing your information will do so only in an authorised manner and are subject to a duty of confidentiality.

We also have procedures in place to deal with any suspected data security breach. We will notify you and any applicable regulator of a suspected data breach where we are legally required to do so.

## Changes to this Privacy Notice

This Privacy Notice will be reviewed from time to time. If we decide to change this Privacy Notice we will post the changes here. However, if we intend to make material changes to the way we use your personal information we will notify you before doing so. Any personal information held will be governed by our most current notice.

## Your right to complain

We hope that we can resolve any query or concern you raise about our use of your information. You can contact us at any time. Any questions, comments and requests regarding this Privacy Notice or any other related matter are welcomed and should be addressed to [dataprotection@canonical.com](mailto:dataprotection@canonical.com) or to the address below:

<div style="margin:2rem;">
Legal, Canonical<br />
4th floor, 201 Borough High St.<br />
London SE1 1JA<br />
United Kingdom<br />
</div>

Alternatively, you can use the relevant contact us form.

If you have a complaint about our use of your information, you can contact the Information Commissioner's Office via their website at [ico.org.uk/make-a-complaint](https://ico.org.uk/make-a-complaint/) or write to them at:

<div style="margin:2rem;">
Information Commissioner's Office<br />
Wycliffe House<br />
Water Lane<br />Wilmslow<br />
Cheshire<br />
SK9 5AF<br />
United Kingdom
</div>
