---
wrapper_template: "legal/_base_legal_markdown.html"
context:
  title: "Privacy notice – Canonical Credentials"
  description: This privacy notice tells you about the information collected from you when you access Canonical Credentials. In collecting this information, we are acting as a data controller and, by law, we are required to provide you with information about us, about why and how we use your data, and about the rights you have over your data.
  copydoc: https://docs.google.com/document/d/1Ovw3ypWDQwxWZ_tU_2U57uWUW-437v6R2UIMX6wfYYg/edit?ts=600ae156#
---

<h4 class="p-muted-heading">Version - February 2023</h4>
<hr style="margin-bottom: 2rem;" />

# Privacy notice – The Canonical Credentials service

This privacy notice tells you about the information collected from you when you access the Canonical Credentials service. In collecting this information, we are acting as a data controller and, by law, we are required to provide you with information about us, about why and how we use your data, and about the rights you have over your data. For more information, please see our <a href="/legal/privacy-policy">privacy policy</a>.

## Who are we?

We are Canonical Group Limited. Our address is 5 New Street Square, London, EC4A 3TW, United Kingdom. You can contact us by post at the above address or by email to <a href="mailto:dataprotection@canonical.com">dataprotection@canonical.com</a> for the attention of “Legal”.

We are not required to have a data protection officer, so any enquiries about our use of your personal data should be addressed to the contact details above.

## What personal data do we collect?

When you register to access the Canonical Credentials service we ask you for your name and email address, timezone, country, IP address and related information. These fields are mandatory for participation in the Canonical Credentials service.

## Why do we collect this information?

We will use your information for carrying out the Canonical Credentials service, including but not limited to making available the exams and training materials, tracking the exams that you have completed and the badges that you have received for passing exams, as well as for user and product research purposes. We ask for your consent to do this and will only contact you for this purpose for as long as you continue to consent.

Where relevant, we will share your information with third party TrueAbility, Inc.  with a registered office at 1150 N. 1604W, Suite 108-244, San Antonio, Texas, 78248. We may also use your information to send you other news and product updates from Canonical. This may involve us calling you, where we have your phone number in order to do so.

## What do we do with your information?

Your information is stored in our database and may be processed outside of the European Economic Area. It is shared with the third parties only as reasonably required for Canonical to process and store your data in accordance with this notice.

Such countries do not have the same data protection laws as the United Kingdom and EEA. Where the European Commission has not given a formal decision that such countries provide an adequate level of data protection similar to those which currently apply to the United Kingdom and EEA, any transfer of your personal information will be subject to approved contract terms designed to help safeguard your privacy rights and give you remedies in the unlikely event of misuse of you personal information. If you would like further information, please contact us (see “Your right to complain” below).

## How long do we keep your information for?

Your information is kept for as long as you continue to consent and for so long as reasonably required thereafter in accordance with our record retention policy.

## Your rights over your information

You have a number of important rights under data protection laws. In summary, those include rights to:

- Fair processing of information and transparency over how we use your personal information.
- Access to your personal information and to certain other supplementary information that this Privacy Notice is already designed to address.
- Require us to correct any mistakes in your information which we hold.
- Require the erasure of personal information concerning you in certain situations.
- Receive the personal information concerning you which you have provided to us, in a structured, commonly used and machine-readable format and have the right to transmit that data to a third party in certain situations.
- Object at any time to processing of personal information concerning you for direct marketing.
- Object to decisions being taken by automated means which produce legal effects concerning you or similarly significantly affect you.
- Object in certain other situations to our continued processing of your personal information.
- Otherwise restrict our processing of your personal information in certain circumstances.
- Claim compensation for damages caused by our breach of any data protection laws.

For further information on each of those rights, including the circumstances in which they apply, see the Guidance from the UK Information Commissioner’s Office (ICO) on individuals rights under the General Data Protection Regulation.

If you would like to exercise any of those rights, please:
1. Email or write to us (see “Your right to complain” below).
2. Provide us enough information to identify you.
3. Provide us proof of your identity and address (a copy of your driving licence or passport and a recent utility or credit card bill).
4. Let us know the information to which your request relates.


If you would like to unsubscribe from any email, you can also click the “unsubscribe” button at the bottom of the email. Please note that unsubscribing is not automatic, but will be implemented once confirmed by our personnel.

## Keeping your personal information secure

We have appropriate security measures in place to prevent personal information from being accidentally lost, or used or accessed in an unauthorised way. We limit access to your personal information to those who have a genuine business need to know it. Those processing your information will do so only in an authorised manner and are subject to a duty of confidentiality.

We also have procedures in place to deal with any suspected data security breach. We will notify you and any applicable regulator of a suspected data breach where we are legally required to do so.

## Your right to complain

We hope that we can resolve any query or concern you raise about our use of your information. You can contact us at any time. Any questions, comments and requests regarding this Privacy notice or any other related matter are welcomed and should be addressed to <a href="mailto:dataprotection@canonical.com">dataprotection@canonical.com</a> or to the address below:

<div style="margin: 2rem;">
  <p>
    Legal, Canonical<br />
    5 New Street Square<br/>
    London, EC4A 3TW<br/>
    United Kingdom<br/> 
  </p>
</div>

Alternatively, you can use the relevant contact us form.

If you have a complaint about our use of your information, you can contact the Information Commissioner's Office via their website at <a href="https://ico.org.uk/make-a-complaint">ico.org.uk/make-a-complaint</a> or write to them at:

<div style="margin: 2rem;">
  <p>
    Information Commissioner's Office<br />
    Wycliffe House<br />
    Water Lane<br />
    Wilmslow<br />
    Cheshire<br />
    SK9 5AF<br />
    United Kingdom
  </p>
</div>
