---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Volcano Scheduler charm"
  description: Deploy, configure and manage the volcano scheduler
keywords: charms, volcano, operators
tags: [operating]
sidebar: k8smain-sidebar
permalink: volcano.html
layout: [base, ubuntu-com]
toc: False
---

Volcano is a batch system built on Kubernetes. 

It provides a suite of mechanisms that are commonly required by many 
classes of batch & elastic workload including: machine learning/deep learning,
bioinformatics/genomics and other "big data" applications. 
These types of applications typically run on generalized domain frameworks 
like TensorFlow, Spark, Ray, PyTorch, MPI, etc, which Volcano integrates with.

This work is based on the upstream project [volcano.sh][upstream].

## Deploying the volcano charms

### Prerequisites 
The Volcano charms must be deployed in a Kubernetes model on your cluster, not
a machine model (i.e., it runs on Kubernetes). These instructions assume you 
have read and followed the instructions for 
[adding your Charmed Kubernetes cluster to your Juju controller][kubernetes-operators]. 
These instructions assume you have a cluster registered with Juju and named `ck8s`. Please 
adjust the commands given appropriately if you have used a different name.

Assuming you have a Charmed Kubernetes deployment running and have copied the kube config file from your control-plane:

If necessary, add a new model to deploy the Volcano charm into. Adding a model creates a Kubernetes namespace behind the scenes:

```bash
juju add-model volcano-system ck8s
```

Next, deploy the Volcano charms. Note that it must be deployed using `--trust`:

```
juju deploy volcano --trust
```

The `--trust` switch means that the Volcano charms will have access to the Juju credentials required to add/remove CRD and webhook.


## Integrations

### Certificates
The `volcano-admission` service is exposed as a service on port 443 for internal communication and comes
by default with self-signed certificates for this service.  Its possible to relate to a certificate 
provider and have its certs generated by a trusted third-party like Vault or EasyRSA. 

```bash
CERT_MODEL=<name of certificate model>
juju switch $CERT_MODEL
juju offer <certificate-application>:client certificates
juju switch volcano-system
juju consume admin/${CERT_MODEL}.certificates
juju relate volcano-admission:certificates certificates
```


<!-- LINKS -->
[Kubernetes-operators]: /kubernetes/docs/operator-charms
[upstream]: https://volcano.sh/

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/volcano.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>
