---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Tutorial topics"
  description: an index of topics in this category
keywords: Cloud, cluster, storage
tags: [operating]
sidebar: k8smain-sidebar
permalink: tutorials-index.html
layout: [base, ubuntu-com]
toc: False
---

This section of our documentation contains step-by-step tutorials to guide you through installing and using **Charmed Kubernetes**.
Our tutorials have been written to make as few assumptions as possible, and to be accessible to everyone. They're an ideal place to start learning.

| Tutorial |  |
|--|--|
| [Quickstart](/kubernetes/docs/quickstart/) | Installation instructions and a quickstart guide |

If you have a specific goal, but are already familiar with Kubernetes, our _How-to_ guides have more practical application. They'll help you achieve an end-result but may require you to understand and adapt the steps to fit your specific requirements.

For a better understanding of how Charmed Kubernetes works, and how it can be used and configured, our _Explanation_ section helps you to expand your knowledge.

Take a look at our _Reference section_ when  you need to know more about versions, releases and other reference material.

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/tutorials-index.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>
