---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Supported versions"
  description: The Charmed Kubernetes release cycle and current supported versions.
keywords: juju, upgrading, track, version
tags: [operating]
sidebar: k8smain-sidebar
permalink: supported-versions.html
layout: [base, ubuntu-com]
toc: False
---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug at 
https://github.com/charmed-kubernetes/kubernetes-docs/issues 
rather than editing the text -->

Charmed Kubernetes officially supports the three most recent minor releases
of Kubernetes. The support window for Charmed Kubernetes is explained more
fully on the [Ubuntu release cycle page](/about/release-cycle#canonical-kubernetes-release-cycle).

Current release: **1.31**

Supported releases (click buttons for more information): 

<div class="row">
 <div class="col-2">
  <span class="u-vertically-center"><a href="/kubernetes/docs/1.31/components" class="p-button--positive">1.31.x</a></span>
 </div>
 <div class="col-2">
  <span class="u-vertically-center"><a href="/kubernetes/docs/1.30/components" class="p-button--positive">1.30.x</a></span>
 </div>
 <div class="col-2">
  <span class="u-vertically-center"><a href="/kubernetes/docs/1.29/components" class="p-button--positive">1.29.x</a></span>
 </div>
</div>

## Charmed Kubernetes bundle versions

**Charmhub.io** hosts Charmed Kubernetes bundles as well as
individual charms. To deploy the latest stable bundle, run the command:

```bash
juju deploy charmed-kubernetes
```

It is also possible to deploy a specific version of the bundle by including
the `--channel` argument. For example, to deploy the Charmed Kubernetes
bundle for the Kubernetes 1.30 release, run the command:

```bash
juju deploy charmed-kubernetes --channel=1.30/stable
```

It is still possible to deploy older, unsupported versions of Charmed Kubernetes.
Older bundle files are available for download in the [releases][] directory of
the Charmed Kubernetes bundle repository. These can be downloaded and deployed with
Juju as with any local bundle file.

<div class="p-notification--caution">
  <p markdown="1" class="p-notification__response">
    <span class="p-notification__status">Note:</span>
Only the latest three versions of Charmed Kubernetes are supported at any time.
  </p>
</div>

## Professional support

For additional support, learn more about [Ubuntu Pro][pro] as well as
[managed Kubernetes solutions][managed] from Canonical.

Please visit the Canonical [Support page][support] for more details of our
professional support programmes.

<!-- LINKS -->

[pro]: /pro
[support]: /support
[managed]: /kubernetes/managed
[releases]: https://github.com/charmed-kubernetes/bundle/tree/main/releases

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/supported-versions.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>
