---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Reference topics"
  description: an index of topics in this category
keywords: Cloud, cluster, storage
tags: [operating]
sidebar: k8smain-sidebar
permalink: reference-index.html
layout: [base, ubuntu-com]
toc: False
---
Our reference pages contain more specific details about **Charmed Kubernetes** you may need to look up from time to time.

| **Reference pages** | Notes |
|--|--|
| [Version info](/kubernetes/docs/supported-versions) | Supported versions and components |
| [Release notes](/kubernetes/docs/release-notes) | |
| [Snap refresh settings](/kubernetes/docs/snap-refresh) | Determining update frequency|
| [Kubernetes Packages](/kubernetes/docs/packages) | Package specifics |
| [Inclusive naming](/kubernetes/docs/inclusive-naming) | Our policy on inclusive language|
| [CIS compliance](/kubernetes/docs/cis-compliance) | CIS test details|
| [Get in touch](/kubernetes/docs/get-in-touch) | |

For a quick start to your Kubernetes journey, our _Tutorials_ section contains a step-by-step tutorial to help you through your first time experience.

If you have a specific goal, but are already familiar with Kubernetes, our _How-to_ guides have more practical application. They'll help you achieve an end-result but may require you to understand and adapt the steps to fit your specific requirements.

For a better understanding of how Charmed Kubernetes works, and how it can be used and configured, our _Explanation_ section helps you to expand your knowledge.

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/reference-index.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>