---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Kubernetes documentation"
  description: Documentation for Charmed Kubernetes.
toc: False
---

Charmed Kubernetes<sup>&reg;</sup>, is pure Kubernetes tested across the widest range of clouds with modern metrics and
 monitoring, brought to you by the people who deliver Ubuntu.

Google, Microsoft, and many other institutions run Kubernetes on Ubuntu because we focus on the latest container 
capabilities in modern kernels. That’s why it’s the top choice for enterprise Kubernetes, too.

[Find out more in the Charmed Kubernetes overview&nbsp;&rsaquo;](/kubernetes/docs/overview)

<img src="https://assets.ubuntu.com/v1/843c77b6-juju-at-a-glace.svg" style="float:right; margin-left: 2rem; border: 0
" alt="">

## In this documentation

<div class="md-table">
<table>
<thead>
<tr>
<th></th>
<th></th>
</tr>
</thead>
<tbody>
<tr>
<td><a href="/kubernetes/docs/tutorials-index">Tutorials</a><br>  Get started with this introduction to Charmed Kubernetes <br></td>
<td><a href="/kubernetes/docs/how-to-index">How-to guides</a> <br> Step-by-step guides covering key operations and common tasks</td>
</tr>
<tr>
<td><a href="/kubernetes/docs/explanation-index">Explanation</a> <br> Concepts - discussion and clarification of key topics</td>
<td><a href="/kubernetes/docs/reference-index">Reference</a> <br> Technical information - specifications, commands, architecture</td>
</tr>
</tbody>
</table>
</div>

---

## Project and community

Charmed Kubernetes is a member of the Ubuntu family. It's an open source project that welcomes community involvement, contributions, suggestions, fixes and constructive feedback.

* [Our Code of Conduct](https://ubuntu.com/community/code-of-conduct)
* [Visit us on Slack at #canonical-kubernetes](https://slack.k8s.io/)
* [Join the Discourse forum](https://discuss.kubernetes.io/)
* [Contribute to our documentation](https://github.com/charmed-kubernetes/kubernetes-docs)
* [Source code and project management](https://github.com/charmed-kubernetes)
