---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Container runtimes"
  description: Using container runtimes in Charmed Kubernetes
keywords: containers, runtimes
tags: [operating]
sidebar: k8smain-sidebar
permalink: how-to-containers.html
layout: [base, ubuntu-com]
toc: False
---

In addition to the standard runtime, Charmed Kubernetes supports a variety of container runtime options. For more specific information, please choose from the topics below:

- [Containerd](/kubernetes/docs/container-runtime)
- [Kata](/kubernetes/docs/kata)
- [VM workloads (KubeVirt)](/kubernetes/docs/kubevirt)
- [GPU workers](/kubernetes/docs/gpu-workers)


<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/how-to-containers.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>