---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Get in Touch"
  description: How to contact the Charmed Kubernetes team
keywords: help, contact, support
tags: [contact]
sidebar: k8smain-sidebar
permalink: get-in-touch.html
layout: [base, ubuntu-com]
toc: False
---

The team behind the **Charmed Kubernetes** are
keen to help and listen to your feedback. There are a variety of ways to get
in touch with suggestions, problems or just to get involved.

## Slack

Find us in **#canonical-kubernetes** on [Kubernetes Slack][slack].

## Bugs

**Charmed Kubernetes** bugs  are tracked in [launchpad][lp].

## Documentation

Visit the [documentation repository][docs] for issues or comments about this documentation.

## Source Code

The source for the bundles and all the core charms for Charmed Kubernetes is
[available on GitHub][source].

## Professional support

If you are looking for additional support, find out about [Ubuntu Advantage][support].

Canonical can also provide [managed solutions][managed] for Kubernetes.

## Contributing

We'd be delighted if you wanted to contribute to any aspect of this open source project. Please see the [docs on contributing][].

<!-- LINKS -->

[docs]:  https://github.com/charmed-kubernetes/kubernetes-docs
[docs on contributing]: /kubernetes/docs/how-to-contribute
[lp]: https://bugs.launchpad.net/charmed-kubernetes
[support]: /support
[managed]: /kubernetes/managed
[slack]: https://communityinviter.com/apps/kubernetes/community
[source]: https://github.com/charmed-kubernetes

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/get-in-touch.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>

