---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: "kubernetes/docs/shared/_side-navigation.md"
context:
  title: "Explanation topics"
  description: an index of topics in this category
keywords: Cloud, cluster, storage
tags: [operating]
sidebar: k8smain-sidebar
permalink: explanation-index.html
layout: [base, ubuntu-com]
toc: False
---
Our explanatory and conceptual guides are written to provide a better understanding of topics related to Charmed Kubernetes and Kubernetes in general. They help you to expand your knowledge and become better at understanding and operating **Charmed Kubernetes**.

| **Explanation guides** | Notes |
|--|--|
| [Charmed Kubernetes overview](/kubernetes/docs/overview) | |
| [Cloud integration](/kubernetes/docs/explain-cloud)| Storage, loadbalancers...|
| [Networking](/kubernetes/docs/cni-overview)| CNIs and networking topics|
| [High Availability](/kubernetes/docs/high-availability)| HA strategies|
| [Security](/kubernetes/docs/security)| Security overview |

For a quick start to your Kubernetes journey, our tutorials section contains a step-by-step tutorial to help you through your first time experience.

If you have a specific goal, but are already familiar with Kubernetes, our _How-to_ guides have more practical application. They'll help you achieve an end-result but may require you to understand and adapt the steps to fit your specific requirements.

Take a look at our  _Reference section_ when  you need to know more about versions, releases and other reference material.

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/explanation-index.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>
