---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: Components of Charmed Kubernetes 1.27
  description: Detailed description of Charmed Kubernetes release
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.27/components.html
layout:
    - base
    - ubuntu-com
toc: false

---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug at 
https://github.com/charmed-kubernetes/kubernetes-docs/issues 
rather than editing the text -->

This page details the charms and container images
which comprise the 1.27 release of Charmed Kubernetes.

Other information about this release can be found on the following pages:

<a class='p-button--brand' href='/kubernetes/docs/1.27/release-notes'>Release notes </a>
<a class='p-button--brand' href='/kubernetes/docs/1.27/upgrading'>Upgrading </a>
<a class='p-button--brand' href='https://bugs.launchpad.net/charmed-kubernetes'>Bugs </a>
<a class='p-button--brand' href='https://github.com/charmed-kubernetes/bundle'>Source </a>
<a class='p-button--brand' href='https://launchpad.net/charmed-kubernetes/+milestone/1.27'>Milestone </a>

## What's new

For a list of new features, changes, deprecations, and bug fixes in this
release, please see the [Release notes](release-notes).

## Core charms

These charms are the core components of the Charmed Kubernetes release.

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [calico](https://charmhub.io/calico) | A robust Software Defined Network from Project Calico | [source](https://github.com/charmed-kubernetes/charm-calico.git) | [docs](https://charmhub.io/calico/docs) | [bugs](https://bugs.launchpad.net/charm-calico) |
| [containerd](https://charmhub.io/containerd) | Containerd container runtime subordinate | [source](https://github.com/charmed-kubernetes/charm-containerd.git) | [docs](https://charmhub.io/containerd/docs) | [bugs](https://bugs.launchpad.net/charm-containerd) |
| [easyrsa](https://charmhub.io/easyrsa) | Deploys and manages EasyRSA to create a Certificate Authority (CA) | [source](https://github.com/charmed-kubernetes/layer-easyrsa.git) | [docs](https://charmhub.io/easyrsa/docs) | [bugs](https://bugs.launchpad.net/charm-easyrsa) |
| [etcd](https://charmhub.io/etcd) | Deploy a TLS terminated ETCD Cluster | [source](https://github.com/charmed-kubernetes/layer-etcd.git) | [docs](https://charmhub.io/etcd/docs) | [bugs](https://bugs.launchpad.net/charm-etcd) |
| [kubeapi-load-balancer](https://charmhub.io/kubeapi-load-balancer) | Nginx Load Balancer | [source](https://github.com/charmed-kubernetes/charm-kubeapi-load-balancer.git) | [docs](https://charmhub.io/kubeapi-load-balancer/docs) | [bugs](https://bugs.launchpad.net/charm-kubeapi-load-balancer) |
| [kubernetes-control-plane](https://charmhub.io/kubernetes-control-plane) | The Kubernetes control plane | [source](https://github.com/charmed-kubernetes/charm-kubernetes-control-plane.git) | [docs](https://charmhub.io/kubernetes-control-plane/docs) | [bugs](https://bugs.launchpad.net/charm-kubernetes-control-plane) |
| [kubernetes-worker](https://charmhub.io/kubernetes-worker) | The workload bearing units of a kubernetes cluster | [source](https://github.com/charmed-kubernetes/charm-kubernetes-worker.git) | [docs](https://charmhub.io/kubernetes-worker/docs) | [bugs](https://bugs.launchpad.net/charm-kubernetes-worker) |


## CNI charms

These are the Container Network Interface (CNI) charms supported by Charmed Kubernetes
(Calico is the default CNI and is also included in the core charms table above).

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [calico](https://charmhub.io/calico) | A robust Software Defined Network from Project Calico | [source](https://github.com/charmed-kubernetes/charm-calico.git) | [docs](https://charmhub.io/calico/docs) | [bugs](https://bugs.launchpad.net/charm-calico) |
| [canal](https://charmhub.io/canal) | A Software Defined Network based on Flannel and Calico | [source](https://github.com/charmed-kubernetes/layer-canal.git) | [docs](https://charmhub.io/canal/docs) | [bugs](https://bugs.launchpad.net/charm-canal) |
| [cilium](https://charmhub.io/cilium) | eBPF-based Networking, Observability, Security | [source](https://github.com/charmed-kubernetes/charm-cilium.git) | [docs](https://charmhub.io/cilium/docs) | [bugs](https://bugs.launchpad.net/charm-cilium) |
| [flannel](https://charmhub.io/flannel) | A charm that provides a robust Software Defined Network | [source](https://github.com/charmed-kubernetes/charm-flannel.git) | [docs](https://charmhub.io/flannel/docs) | [bugs](https://bugs.launchpad.net/charm-flannel) |
| [kube-ovn](https://charmhub.io/kube-ovn) | A Software Defined Network based on Kube-OVN | [source](https://github.com/charmed-kubernetes/charm-kube-ovn.git) | [docs](https://charmhub.io/kube-ovn/docs) | [bugs](https://bugs.launchpad.net/charm-kube-ovn) |
| [multus](https://charmhub.io/multus) | a CNI plugin for attaching multiple network interfaces | [source](https://github.com/charmed-kubernetes/charm-multus.git) | [docs](https://charmhub.io/multus/docs) | [bugs](https://bugs.launchpad.net/charm-multus) |
| [sriov-cni](https://charmhub.io/sriov-cni) | Attach SR-IOV Virtual Functions (VFs) directly to pods | [source](https://github.com/charmed-kubernetes/charm-sriov-cni.git) | [docs](https://charmhub.io/sriov-cni/docs) | [bugs](https://bugs.launchpad.net/charm-sriov-cni) |
| [sriov-network-device-plugin](https://charmhub.io/sriov-network-device-plugin) | Enable SR-IOV support | [source](https://github.com/charmed-kubernetes/charm-sriov-network-device-plugin.git) | [docs](https://charmhub.io/sriov-network-device-plugin/docs) | [bugs](https://bugs.launchpad.net/charm-sriov-network-device-plugin) |
| [tigera-secure-ee](https://charmhub.io/tigera-secure-ee) | Tigera Secure Enterprise Edition | [source](https://github.com/charmed-kubernetes/layer-tigera-secure-ee.git) | [docs](https://charmhub.io/tigera-secure-ee/docs) | [bugs](https://bugs.launchpad.net/charm-tigera-secure-ee) |


## Cloud provider charms

These charms provide cloud integrations to Charmed Kubernetes to enable features
such as cloud-native load balancing and storage.

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [aws-cloud-provider](https://charmhub.io/aws-cloud-provider) | Charm which enables out-of-tree AWS cloud-provider for Charmed Kubernetes. | [source](https://github.com/charmed-kubernetes/charm-aws-cloud-provider.git) | [docs](https://charmhub.io/aws-cloud-provider/docs) | [bugs](https://bugs.launchpad.net/charm-aws-cloud-provider) |
| [aws-integrator](https://charmhub.io/aws-integrator) | Charm to enable AWS integrations via Juju relations. | [source](https://github.com/juju-solutions/charm-aws-integrator.git) | [docs](https://charmhub.io/aws-integrator/docs) | [bugs](https://bugs.launchpad.net/charm-aws-integrator) |
| [aws-k8s-storage](https://charmhub.io/aws-k8s-storage) | Charm which enables out-of-tree AWS storage for Charmed Kubernetes. | [source](https://github.com/charmed-kubernetes/aws-k8s-storage.git) | [docs](https://charmhub.io/aws-k8s-storage/docs) | [bugs](https://bugs.launchpad.net/charm-aws-k8s-storage) |
| [azure-cloud-provider](https://charmhub.io/azure-cloud-provider) | Charm which enables Azure out-of-tree integrations for Charmed Kubernetes | [source](https://github.com/charmed-kubernetes/charm-azure-cloud-provider.git) | [docs](https://charmhub.io/azure-cloud-provider/docs) | [bugs](https://bugs.launchpad.net/charm-azure-cloud-provider) |
| [azure-integrator](https://charmhub.io/azure-integrator) | Charm which enables Azure integrations for Juju | [source](https://github.com/juju-solutions/charm-azure-integrator.git) | [docs](https://charmhub.io/azure-integrator/docs) | [bugs](https://bugs.launchpad.net/charm-azure-integrator) |
| [gcp-integrator](https://charmhub.io/gcp-integrator) | Charm which enables Google GCP integrations for Juju | [source](https://github.com/juju-solutions/charm-gcp-integrator.git) | [docs](https://charmhub.io/gcp-integrator/docs) | [bugs](https://bugs.launchpad.net/charm-gcp-integrator) |
| [gcp-k8s-storage](https://charmhub.io/gcp-k8s-storage) | Charm which enables out-of-tree GCP storage for Charmed Kubernetes. | [source](https://github.com/charmed-kubernetes/gcp-k8s-storage.git) | [docs](https://charmhub.io/gcp-k8s-storage/docs) | [bugs](https://bugs.launchpad.net/charm-gcp-k8s-storage) |
| [openstack-integrator](https://charmhub.io/openstack-integrator) | Charm which enables OpenStack integrations for Juju | [source](https://github.com/juju-solutions/charm-openstack-integrator.git) | [docs](https://charmhub.io/openstack-integrator/docs) | [bugs](https://bugs.launchpad.net/charm-openstack-integrator) |
| [vsphere-cloud-provider](https://charmhub.io/vsphere-cloud-provider) | Charm which enables vSphere out of tree provider for Juju | [source](https://github.com/charmed-kubernetes/vsphere-cloud-provider.git) | [docs](https://charmhub.io/vsphere-cloud-provider/docs) | [bugs](https://bugs.launchpad.net/charm-vsphere-cloud-provider) |
| [vsphere-integrator](https://charmhub.io/vsphere-integrator) | Charm which enables vSphere integrations for Juju | [source](https://github.com/juju-solutions/charm-vsphere-integrator.git) | [docs](https://charmhub.io/vsphere-integrator/docs) | [bugs](https://bugs.launchpad.net/charm-vsphere-integrator) |


## Additional charms

These charms are also maintained and supported by the Charmed Kubernetes team
to extend the capabilities of your Kubernetes cluster.

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [aws-iam](https://charmhub.io/aws-iam) |  | [source](https://github.com/charmed-kubernetes/charm-aws-iam.git) | [docs](https://charmhub.io/aws-iam/docs)  | [bugs](https://bugs.launchpad.net/charm-aws-iam) |
| [ceph-csi](https://charmhub.io/ceph-csi) | Deploys Container Storage Interface (CSI) plugin that enables Charmed Kubernetes to use ceph as a storage backend. | [source](https://github.com/charmed-kubernetes/ceph-csi-operator.git) | [docs](https://charmhub.io/ceph-csi/docs)  | [bugs](https://bugs.launchpad.net/charm-ceph-csi) |
| [coredns](https://charmhub.io/coredns) | The CoreDNS domain name service provider | [source](https://github.com/charmed-kubernetes/charm-coredns.git) | [docs](https://charmhub.io/coredns/docs)  | [bugs](https://bugs.launchpad.net/charm-coredns) |
| [docker-registry](https://charmhub.io/docker-registry) | Registry for docker images | [source](https://github.com/CanonicalLtd/docker-registry-charm.git) | [docs](https://charmhub.io/docker-registry/docs)  | [bugs](https://bugs.launchpad.net/layer-docker-registry) |
| [gatekeeper-audit](https://charmhub.io/gatekeeper-audit) | Audit charm for Gatekeeper audit | [source](https://github.com/charmed-kubernetes/opa-gatekeeper-operators.git) | [docs](https://charmhub.io/gatekeeper-audit/docs)  | [bugs](https://bugs.launchpad.net/opa-gatekeeper-operator) |
| [gatekeeper-controller-manager](https://charmhub.io/gatekeeper-controller-manager) | Controller charm for Gatekeeper | [source](https://github.com/charmed-kubernetes/opa-gatekeeper-operators.git) | [docs](https://charmhub.io/gatekeeper-controller-manager/docs)  | [bugs](https://bugs.launchpad.net/opa-gatekeeper-operator) |
| [kata](https://charmhub.io/kata) | Kata untrusted container runtime subordinate | [source](https://github.com/charmed-kubernetes/charm-kata.git) | [docs](https://charmhub.io/kata/docs)  | [bugs](https://bugs.launchpad.net/charm-kata) |
| [keepalived](https://charmhub.io/keepalived) | Failover and monitoring daemon for LVS clusters | [source](https://github.com/charmed-kubernetes/charm-keepalived.git) | [docs](https://charmhub.io/keepalived/docs)  | [bugs](https://bugs.launchpad.net/charm-keepalived) |
| [kube-state-metrics](https://charmhub.io/kube-state-metrics) | a service that listens to the Kubernetes API and generates metrics | [source](https://github.com/charmed-kubernetes/kube-state-metrics-operator.git) | [docs](https://charmhub.io/kube-state-metrics/docs)  | [bugs](https://bugs.launchpad.net/kube-state-metrics-operator) |
| [kubernetes-autoscaler](https://charmhub.io/kubernetes-autoscaler) | automatically scales up and down a kubernetes cluster | [source](https://github.com/charmed-kubernetes/charm-kubernetes-autoscaler.git) | [docs](https://charmhub.io/kubernetes-autoscaler/docs)  | [bugs](https://bugs.launchpad.net/charm-kubernetes-autoscaler) |
| [kubernetes-e2e](https://charmhub.io/kubernetes-e2e) | End-to-end (e2e) tests for Kubernetes | [source](https://github.com/charmed-kubernetes/charm-kubernetes-e2e.git) | [docs](https://charmhub.io/kubernetes-e2e/docs)  | [bugs](https://bugs.launchpad.net/charm-kubernetes-e2e) |
| [kubernetes-metrics-server](https://charmhub.io/kubernetes-metrics-server) | Exposes core Kubernetes metrics via metrics API | [source](https://github.com/charmed-kubernetes/kubernetes-metrics-server-operator.git) | [docs](https://charmhub.io/kubernetes-metrics-server/docs)  | [bugs](https://bugs.launchpad.net/charm-kubernetes-metrics-server) |
| [kubevirt](https://charmhub.io/kubevirt) | Deploys KubeVirt into a Charmed-Kubernetes cluster | [source](https://github.com/charmed-kubernetes/charm-kube-virt.git) | [docs](https://charmhub.io/kubevirt/docs)  | [bugs](https://bugs.launchpad.net/charm-kubevirt) |
| [metallb-controller](https://charmhub.io/metallb-controller) | Controller charm for the metallb loadbalancer | [source](https://github.com/charmed-kubernetes/metallb-operator.git) | [docs](https://charmhub.io/metallb-controller/docs)  | [bugs](https://bugs.launchpad.net/operator-metallb) |
| [metallb-speaker](https://charmhub.io/metallb-speaker) | Speaker charm for the metallb loadbalancer | [source](https://github.com/charmed-kubernetes/metallb-operator.git) | [docs](https://charmhub.io/metallb-speaker/docs)  | [bugs](https://bugs.launchpad.net/operator-metallb) |
| [volcano-admission](https://charmhub.io/volcano-admission) | Volcano is a batch system built on Kubernetes. | [source](https://github.com/charmed-kubernetes/charm-volcano) | [docs](https://discourse.charmhub.io/t/volcano-docs-index/9600)  | [bugs](https://bugs.launchpad.net/charm-volcano) |
| [volcano-controllers](https://charmhub.io/volcano-controllers) | Volcano is a batch system built on Kubernetes. | [source](https://github.com/charmed-kubernetes/charm-volcano) | [docs](https://discourse.charmhub.io/t/volcano-docs-index/9600)  | [bugs](https://bugs.launchpad.net/charm-volcano) |
| [volcano-scheduler](https://charmhub.io/volcano-scheduler) | Volcano is a batch system built on Kubernetes. | [source](https://github.com/charmed-kubernetes/charm-volcano) | [docs](https://discourse.charmhub.io/t/volcano-docs-index/9600)  | [bugs](https://bugs.launchpad.net/charm-volcano) |


## Images

These are the container images used by this release:

<!-- GENERATED CONTAINER IMAGES -->

-  addon-resizer-amd64:1.8.9
-  addon-resizer-arm64:1.8.9
-  addon-resizer-ppc64le:1.8.9
-  addon-resizer-s390x:1.8.9
-  calico/cni:v3.21.4
-  calico/kube-controllers:v3.21.4
-  calico/node:v3.21.4
-  calico/pod2daemon-flexvol:v3.21.4
-  cdkbot/microbot-amd64:latest
-  cdkbot/microbot-arm64:latest
-  cdkbot/microbot-s390x:latest
-  cephcsi/cephcsi:v3.7.2
-  cloud-provider-vsphere/cpi/release/manager:v1.26.0
-  cloud-provider-vsphere/csi/release/driver:v3.0.0
-  cloud-provider-vsphere/csi/release/syncer:v3.0.0
-  coredns/coredns:1.9.4
-  defaultbackend-amd64:1.5
-  defaultbackend-arm64:1.5
-  defaultbackend-ppc64le:1.5
-  defaultbackend-s390x:1.4
-  dns/k8s-dns-dnsmasq-nanny:1.22.20
-  dns/k8s-dns-kube-dns:1.22.20
-  dns/k8s-dns-sidecar:1.22.20
-  external_storage/nfs-client-provisioner:v3.1.0-k8s1.11
-  ingress-nginx/controller:v1.6.4
-  kube-state-metrics/kube-state-metrics:v2.8.2
-  kubernetes-ingress-controller/nginx-ingress-controller-ppc64le:0.20.0
-  kubernetesui/dashboard:v2.7.0
-  kubernetesui/metrics-scraper:v1.0.8
-  metrics-server/metrics-server:v0.5.2
-  nvidia/k8s-device-plugin:v0.14.0
-  pause:3.6
-  provider-os/cinder-csi-plugin:v1.26.2
-  provider-os/k8s-keystone-auth:v1.26.2
-  provider-os/openstack-cloud-controller-manager:v1.26.2
-  sig-storage/csi-attacher:v3.5.0
-  sig-storage/csi-attacher:v4.0.0
-  sig-storage/csi-attacher:v4.2.0
-  sig-storage/csi-node-driver-registrar:v2.5.1
-  sig-storage/csi-node-driver-registrar:v2.6.2
-  sig-storage/csi-node-driver-registrar:v2.7.0
-  sig-storage/csi-provisioner:v3.2.1
-  sig-storage/csi-provisioner:v3.3.0
-  sig-storage/csi-provisioner:v3.4.0
-  sig-storage/csi-resizer:v1.4.0
-  sig-storage/csi-resizer:v1.5.0
-  sig-storage/csi-resizer:v1.7.0
-  sig-storage/csi-snapshotter:v6.0.1
-  sig-storage/csi-snapshotter:v6.1.0
-  sig-storage/csi-snapshotter:v6.2.1
-  sig-storage/livenessprobe:v2.8.0
-  sig-storage/livenessprobe:v2.9.0


<!-- CONTAINER IMAGES END -->

<!-- LINKS -->

[release notes]: /kubernetes/docs/release-notes#1.27
[upgrade notes]: /kubernetes/docs/upgrade-notes
[bugs]: /kubernetes/docs/
[source]: https://github.com/charmed-kubernetes
[1.27 milestone]: https://launchpad.net/charmed-kubernetes/+milestone/1.27

<!-- FEEDBACK -->
<div class="p-notification--information">
  <div class="p-notification__content">
    <p class="p-notification__message">We appreciate your feedback on the documentation. You can
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/edit/main/pages/k8s/1.27/components.md" >edit this page</a>
    or
    <a href="https://github.com/charmed-kubernetes/kubernetes-docs/issues/new">file a bug here</a>.</p>
    <p>See the guide to <a href="/kubernetes/docs/how-to-contribute"> contributing </a> or discuss these docs in our <a href="https://chat.charmhub.io/charmhub/channels/kubernetes"> public Mattermost channel</a>.</p>
  </div>
</div>
