---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: Components of Charmed Kubernetes 1.24
  description: Detailed description of Charmed Kubernetes release
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.24/components.html
layout:
    - base
    - ubuntu-com
toc: false

---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug at 
https://github.com/charmed-kubernetes/kubernetes-docs/issues 
rather than editing the text -->

This page details the charms, snaps, images and other components
which comprise the 1.24 release of Charmed Kubernetes.

Other information about this release can be found on the following pages:

<a class='p-button--brand' href='/kubernetes/docs/1.24/release-notes'>Release notes </a>
<a class='p-button--brand' href='/kubernetes/docs/1.24/upgrading'>Upgrading </a>
<a class='p-button--brand' href='https://bugs.launchpad.net/charmed-kubernetes'>Bugs </a>
<a class='p-button--brand' href='https://github.com/charmed-kubernetes/bundle'>Source </a>
<a class='p-button--brand' href='https://launchpad.net/charmed-kubernetes/+milestone/1.24'>Milestone </a>

## What's new

For a list of new features, changes, deprecations, and bug fixes in this
release, please see the [Release notes](release-notes).

## Core charms

These charms are the core components or official optional components of the
release. These charms are maintained by the Charmed Kubernetes team.

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [calico](https://charmhub.io/calico) | A robust Software Defined Network from Project Calico | [source](https://github.com/charmed-kubernetes/layer-calico.git) | [docs](https://charmhub.io/calico/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [containerd](https://charmhub.io/containerd) | Containerd container runtime subordinate | [source](https://github.com/charmed-kubernetes/charm-containerd.git) | [docs](https://charmhub.io/containerd/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [easyrsa](https://charmhub.io/easyrsa) | Deploys and manages EasyRSA to create a Certificate Authority (CA) | [source](https://github.com/charmed-kubernetes/layer-easyrsa.git) | [docs](https://charmhub.io/easyrsa/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [etcd](https://charmhub.io/etcd) | Deploy a TLS terminated ETCD Cluster | [source](https://github.com/charmed-kubernetes/layer-etcd.git) | [docs](https://charmhub.io/etcd/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kata](https://charmhub.io/kata) | Kata untrusted container runtime subordinate | [source](https://github.com/charmed-kubernetes/charm-kata.git) | [docs](https://charmhub.io/kata/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubeapi-load-balancer](https://charmhub.io/kubeapi-load-balancer) | Nginx Load Balancer | [source](https://github.com/charmed-kubernetes/charm-kubeapi-load-balancer.git) | [docs](https://charmhub.io/kubeapi-load-balancer/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubernetes-control-plane](https://charmhub.io/kubernetes-control-plane) | The Kubernetes control plane | [source](https://github.com/charmed-kubernetes/charm-kubernetes-control-plane.git) | [docs](https://charmhub.io/kubernetes-control-plane/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubernetes-worker](https://charmhub.io/kubernetes-worker) | The workload bearing units of a kubernetes cluster | [source](https://github.com/charmed-kubernetes/charm-kubernetes-worker.git) | [docs](https://charmhub.io/kubernetes-worker/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |

## CNI charms 

These are the CNI charms also supported by Charmed Kubernetes ( calico is the default CNI and is included in the core charms above)

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [canal](https://charmhub.io/canal) | A Software Defined Network based on Flannel and Calico | [source](https://github.com/charmed-kubernetes/layer-canal.git) | [docs](https://charmhub.io/canal/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [flannel](https://charmhub.io/flannel) | A charm that provides a robust Software Defined Network | [source](https://github.com/charmed-kubernetes/charm-flannel.git) | [docs](https://charmhub.io/flannel/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [tigera-secure-ee](https://charmhub.io/tigera-secure-ee) | Tigera Secure Enterprise Edition | [source](https://github.com/charmed-kubernetes/layer-tigera-secure-ee.git) | [docs](https://charmhub.io/tigera-secure-ee/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [multus](https://charmhub.io/multus) | a CNI plugin for attaching multiple network interfaces | [source](https://github.com/charmed-kubernetes/charm-multus.git) | [docs](https://charmhub.io/multus/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [sriov-cni](https://charmhub.io/sriov-cni) | Attach SR-IOV Virtual Functions (VFs) directly to pods | [source](https://github.com/charmed-kubernetes/charm-sriov-cni.git) | [docs](https://charmhub.io/sriov-cni/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [sriov-network-device-plugin](https://charmhub.io/sriov-network-device-plugin) | Enable SR-IOV support | [source](https://github.com/charmed-kubernetes/charm-sriov-network-device-plugin.git) | [docs](https://charmhub.io/sriov-network-device-plugin/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [coredns](https://charmhub.io/coredns) | The CoreDNS domain name service provider | [source](https://github.com/charmed-kubernetes/charm-coredns.git) | [docs](https://charmhub.io/coredns/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |

## Integrator charms

These charms provide cloud integration for Charmed Kubernetes (e.g. for running native loadbalancers and storage).

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [azure-integrator](https://charmhub.io/azure-integrator) |  | [source](https://github.com/juju-solutions/charm-azure-integrator.git) | [docs](https://charmhub.io/azure-integrator/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [gcp-integrator](https://charmhub.io/gcp-integrator) | Charm which enables Google GCP integrations for Juju | [source](https://github.com/juju-solutions/charm-gcp-integrator.git) | [docs](https://charmhub.io/gcp-integrator/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [aws-integrator](https://charmhub.io/aws-integrator) | Charm to enable AWS integrations via Juju relations. | [source](https://github.com/juju-solutions/charm-aws-integrator.git) | [docs](https://charmhub.io/aws-integrator/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [openstack-integrator](https://charmhub.io/openstack-integrator) | Charm which enables OpenStack integrations for Juju | [source](https://github.com/juju-solutions/charm-openstack-integrator.git) | [docs](https://charmhub.io/openstack-integrator/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [vsphere-integrator](https://charmhub.io/vsphere-integrator) | Charm which enables vSphere integrations for Juju | [source](https://github.com/juju-solutions/charm-vsphere-integrator.git) | [docs](https://charmhub.io/vsphere-integrator/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |

## Additional charms

These charms are also maintained and supported by the Charmed Kubernetes team to provide extra features for your K8s cluster.

|charm | summary | source | docs | bugs |
|-|-|-|-|-|
| [kube-state-metrics](https://charmhub.io/kube-state-metrics) | a service that listens to the Kubernetes API and generates metrics | [source](https://github.com/charmed-kubernetes/kube-state-metrics-operator.git) | [docs](https://charmhub.io/kube-state-metrics/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubernetes-autoscaler](https://charmhub.io/kubernetes-autoscaler) | automatically scales up and down a kubernetes cluster | [source](https://github.com/charmed-kubernetes/charm-kubernetes-autoscaler.git) | [docs](https://charmhub.io/kubernetes-autoscaler/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubernetes-e2e](https://charmhub.io/kubernetes-e2e) | End-to-end (e2e) tests for Kubernetes | [source](https://github.com/charmed-kubernetes/charm-kubernetes-e2e.git) | [docs](https://charmhub.io/kubernetes-e2e/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [kubernetes-metrics-server](https://charmhub.io/kubernetes-metrics-server) | Exposes core Kubernetes metrics via metrics API  | [source](https://github.com/charmed-kubernetes/kubernetes-metrics-server-operator.git) | [docs](https://charmhub.io/kubernetes-metrics-server/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [keepalived](https://charmhub.io/keepalived) | Failover and monitoring daemon for LVS clusters | [source](https://github.com/charmed-kubernetes/charm-keepalived.git) | [docs](https://charmhub.io/keepalived/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [docker-registry](https://charmhub.io/docker-registry) | Registry for docker images | [source](https://github.com/CanonicalLtd/docker-registry-charm.git) | [docs](https://charmhub.io/docker-registry/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [aws-iam](https://charmhub.io/aws-iam) |  | [source](https://github.com/charmed-kubernetes/charm-aws-iam.git) | [docs](https://charmhub.io/aws-iam/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [metallb-controller](https://charmhub.io/metallb-controller) | Controller charm for the metallb loadbalancer | [source](https://github.com/charmed-kubernetes/metallb-operator.git) | [docs](https://charmhub.io/metallb-controller/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |
| [metallb-speaker](https://charmhub.io/metallb-speaker) | Speaker charm for the metallb loadbalancer | [source](https://github.com/charmed-kubernetes/metallb-operator.git) | [docs](https://charmhub.io/metallb-speaker/docs) | [bugs](https://bugs.launchpad.net/charmed-kubernetes) |

## Images

These are the container images used by this release:

<!-- GENERATED CONTAINER IMAGES -->

-  addon-resizer-amd64:1.8.9
-  addon-resizer-arm64:1.8.9
-  addon-resizer-ppc64le:1.8.9
-  addon-resizer-s390x:1.8.9
-  calico/cni:v3.21.4
-  calico/kube-controllers:v3.21.4
-  calico/node:v3.21.4
-  calico/pod2daemon-flexvol:v3.21.4
-  cdkbot/microbot-amd64:latest
-  cdkbot/microbot-arm64:latest
-  cdkbot/microbot-s390x:latest
-  cephcsi/cephcsi:v3.5.1
-  coredns/coredns:1.9.0
-  defaultbackend-amd64:1.5
-  defaultbackend-arm64:1.5
-  defaultbackend-ppc64le:1.5
-  defaultbackend-s390x:1.4
-  dns/k8s-dns-dnsmasq-nanny:1.21.1
-  dns/k8s-dns-kube-dns:1.21.1
-  dns/k8s-dns-sidecar:1.21.1
-  external_storage/nfs-client-provisioner:v3.1.0-k8s1.11
-  k8s-artifacts-prod/ingress-nginx/controller:v1.2.0
-  k8scloudprovider/cinder-csi-plugin:v1.23.0
-  k8scloudprovider/k8s-keystone-auth:v1.23.0
-  k8scloudprovider/openstack-cloud-controller-manager:v1.23.0
-  kube-state-metrics/kube-state-metrics:v2.4.2
-  kubernetes-ingress-controller/nginx-ingress-controller-ppc64le:0.20.0
-  kubernetesui/dashboard:v2.5.1
-  kubernetesui/metrics-scraper:v1.0.7
-  metrics-server/metrics-server:v0.5.2
-  nvidia/k8s-device-plugin:v0.12.2
-  pause:3.6
-  sig-storage/csi-attacher:v3.3.0
-  sig-storage/csi-attacher:v3.4.0
-  sig-storage/csi-node-driver-registrar:v2.4.0
-  sig-storage/csi-provisioner:v3.0.0
-  sig-storage/csi-provisioner:v3.1.0
-  sig-storage/csi-resizer:v1.3.0
-  sig-storage/csi-snapshotter:v4.2.0
-  sig-storage/csi-snapshotter:v4.2.1
-  sig-storage/livenessprobe:v2.5.0

<!-- CONTAINER IMAGES END -->

<!-- LINKS -->
[release notes]: /kubernetes/docs/release-notes#1.24
[upgrade notes]: /kubernetes/docs/upgrade-notes
[bugs]: /kubernetes/docs/
[source]: https://github.com/charmed-kubernetes
[1.24 milestone]: https://launchpad.net/charmed-kubernetes/+milestone/1.24

