---
wrapper_template: templates/docs/markdown.html
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Gcp-integrator charm '
  description: "Charm to enable GCP integrations via Juju relations.\n"
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.23/charm-gcp-integrator.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '166'
bundle_release: '1.23'
---

This charm acts as a proxy to GCP and provides an [interface][] to apply a
certain set of changes via roles, profiles, and tags to the instances of
the applications that are related to this charm.

## Usage

When on GCP, this charm can be deployed, granted trust via Juju to access GCP,
and then related to an application that supports the [interface][].

For example, [Charmed Kubernetes][] has support for this, and can be deployed with the
following bundle overlay:

```yaml
applications:
  gcp-integrator:
    charm: cs:~containers/gcp-integrator
    num_units: 1
relations:
  - ['gcp-integrator', 'kubernetes-master']
  - ['gcp-integrator', 'kubernetes-worker']
```

Then deploy Charmed Kubernetes using this overlay:

```
juju deploy cs:charmed-kubernetes --overlay ./k8s-gcp-overlay.yaml
```

The charm then needs to be granted access to credentials that it can use to
setup integrations.  Using Juju 2.4 or later, you can easily grant access to
the credentials used deploy the integrator itself:

```
juju trust gcp-integrator
```

To deploy with earlier versions of Juju, or if you wish to provide it different
credentials, you will need to provide the cloud credentials via the `credentials`,
charm config options.

**Note:** The credentials used must be [enabled to use the API][iam-api] to
inspect the instances connecting to it, enable a service account for those
instances, assign roles to those instances, and create custom roles.

# Resource Usage Note

By relating to this charm, other charms can directly allocate resources, such
as PersistentDisk volumes and Load Balancers, which could lead to cloud charges
and count against quotas.  Because these resources are not managed by Juju,
they will not be automatically deleted when the models or applications are
destroyed, nor will they show up in Juju's status or GUI.  It is therefore up
to the operator to manually delete these resources when they are no longer
needed, using the Google Cloud console or API.

# Examples

Following are some examples using GCP integration with Charmed Kubernetes.

## Creating a pod with a PersistentDisk-backed volume

This script creates a busybox pod with a persistent volume claim backed by
GCE's PersistentDisk.

```sh
#!/bin/bash

# create a storage class using the `kubernetes.io/gce-pd` provisioner
kubectl create -f - <<EOY
apiVersion: storage.k8s.io/v1
kind: StorageClass
metadata:
  name: gce-standard
provisioner: kubernetes.io/gce-pd
parameters:
  type: pd-standard
EOY

# create a persistent volume claim using that storage class
kubectl create -f - <<EOY
kind: PersistentVolumeClaim
apiVersion: v1
metadata:
  name: testclaim
spec:
  accessModes:
    - ReadWriteOnce
  resources:
    requests:
      storage: 100Mi
  storageClassName: gce-standard
EOY

# create the busybox pod with a volume using that PVC:
kubectl create -f - <<EOY
apiVersion: v1
kind: Pod
metadata:
  name: busybox
  namespace: default
spec:
  containers:
    - image: busybox
      command:
        - sleep
        - "3600"
      imagePullPolicy: IfNotPresent
      name: busybox
      volumeMounts:
        - mountPath: "/pv"
          name: testvolume
  restartPolicy: Always
  volumes:
    - name: testvolume
      persistentVolumeClaim:
        claimName: testclaim
EOY
```

## Creating a service with a GCE load-balancer

The following script starts the hello-world pod behind a GCE-backed load-balancer.

```bash
kubectl create deployment hello-world --image=gcr.io/google-samples/node-hello:1.0
kubectl scale deployment hello-world --replicas=5
kubectl expose deployment hello-world --type=LoadBalancer --name=hello --port=8080
watch kubectl get svc hello -o wide
```


<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-credentials"> </a> credentials | string |  | [See notes](#credentials-description)  |
| <a id="table-snap_proxy"> </a> snap_proxy | string |  | DEPRECATED. Use snap-http-proxy and snap-https-proxy model configuration settings. HTTP/HTTPS web proxy for Snappy to use when accessing the snap store.  |
| <a id="table-snap_proxy_url"> </a> snap_proxy_url | string |  | DEPRECATED. Use snap-store-proxy model configuration setting. The address of a Snap Store Proxy to use for snaps e.g. http://snap-proxy.example.com  |
| <a id="table-snapd_refresh"> </a> snapd_refresh | string |  | [See notes](#snapd_refresh-description)  |

---

### credentials


<a id="credentials-description"> </a>
**Description:**

The base64-encoded contents of an GCP credentials JSON file.

This can be used from bundles with 'include-base64://' (see
https://discourse.charmhub.io/t/bundle-reference/1158),
or from the command-line with 'juju config gcp credentials="$(base64 /path/to/file)"'.

It is strongly recommended that you use 'juju trust' instead, if available.

[Back to table](#table-credentials)


### snapd_refresh


<a id="snapd_refresh-description"> </a>
**Description:**

How often snapd handles updates for installed snaps. The default (an empty string) is 4x per day. Set to "max" to check once per month based on the charm deployment date. You may also set a custom string as described in the 'refresh.timer' section here:
  https://forum.snapcraft.io/t/system-options/87

[Back to table](#table-snapd_refresh)



<!-- CONFIG ENDS -->

<!-- ACTIONS STARTS -->
<!-- AUTOGENERATED TEXT - DO NOT EDIT -->

You can run an action with the following

```bash
juju run-action gcp-integrator ACTION [parameters] [--wait]
```
<div class="row">
  <div class="col-2">
    <h5>
      list-service-accounts
    </h5>
  </div>
  <div class="col-5">
    <p>
      List all service accounts created by this charm (i.e., with the prefix `juju-gcp-`), both active and unknown (i.e., created by another instance of this charm or no longer in use).
    </p>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      purge-unknown-service-accounts
    </h5>
  </div>
  <div class="col-5">
    <p>
      Purge service accounts created by this charm (i.e., with the prefix `juju-gcp-`) that are no longer in active use by this charm. Be careful! There is no way for this action to determine if these accounts are in use elsewhere, such as in another model. Running this action while there are accounts in use elsewhere will likely break the applications depending on those accounts.
    </p>
  </div>
</div>
<hr>

<!-- ACTIONS ENDS -->









[interface]: https://github.com/juju-solutions/interface-gcp-integration
[api-doc]: https://github.com/juju-solutions/interface-gcp-integration/blob/master/docs/requires.md
[Charmed Kubernetes]: https://jaas.ai/charmed-kubernetes
[iam-api]: https://console.developers.google.com/apis/api/iam.googleapis.com/overview
