---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: Components of Charmed Kubernetes 1.22
  description: Detailed description of Charmed Kubernetes release
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.22/components.html
layout:
    - base
    - ubuntu-com
toc: false
bundle_revision: '814'
bundle_release: '1.22'
---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug at 
https://github.com/charmed-kubernetes/kubernetes-docs/issues 
rather than editing the text -->

This page details the charms, snaps, images and other components
which comprise the 1.22 release of Charmed Kubernetes.

Other information about this release can be found on the following pages:

<a class='p-button--brand' href='/kubernetes/docs/1.22/release-notes'>Release notes </a>
<a class='p-button--brand' href='/kubernetes/docs/1.22/upgrading'>Upgrading </a>
<a class='p-button--brand' href='https://bugs.launchpad.net/charmed-kubernetes'>Bugs </a>
<a class='p-button--brand' href='https://github.com/charmed-kubernetes/bundle'>Source </a>
<a class='p-button--brand' href='https://launchpad.net/charmed-kubernetes/+milestone/1.22'>Milestone </a>

## What's new

For a list of new features, changes, deprecations, and bug fixes in this
release, please see the [Release notes](release-notes).

## Core charms

These charms are the core components or official optional components of the
release. These charms are maintained by the Charmed Kubernetes team.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>docs</th>
      <th>source</th>
      <th>bugs</th>
      <th>version</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> aws-iam </td>
  <td> A charm that enables using AWS IAM to authenticate with Kubernetes </td>
  <td> <a href="/kubernetes/docs/1.22/charm-aws-iam">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/charm-aws-iam"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 94 </td>
  <td> -- </td>
</tr>
<tr>
  <td> aws-integrator </td>
  <td> Charm to enable AWS integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-aws-integrator">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-aws-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 153 </td>
  <td> -- </td>
</tr>
<tr>
  <td> azure-integrator </td>
  <td> Proxy charm to enable Azure integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-azure-integrator">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-azure-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 137 </td>
  <td> -- </td>
</tr>
<tr>
  <td> calico </td>
  <td> A robust Software Defined Network from Project Calico </td>
  <td> <a href="/kubernetes/docs/1.22/charm-calico">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/layer-calico"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 838 </td>
  <td> -- </td>
</tr>
<tr>
  <td> canal </td>
  <td> A Software Defined Network based on Flannel and Calico </td>
  <td> <a href="/kubernetes/docs/1.22/charm-canal">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/layer-canal"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 837 </td>
  <td> -- </td>
</tr>
<tr>
  <td> containerd </td>
  <td> Containerd container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.22/charm-containerd">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/charm-containerd"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 178 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker </td>
  <td> Docker container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.22/charm-docker">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/layer-docker"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 131 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker-registry </td>
  <td> Registry for docker images </td>
  <td> <a href="/kubernetes/docs/1.22/charm-docker-registry">docs</a> </td> 
  <td> <a href="https://github.com/CanonicalLtd/docker-registry-charm"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 218 </td>
  <td> -- </td>
</tr>
<tr>
  <td> easyrsa </td>
  <td> Delivers EasyRSA to create a Certificate Authority (CA). </td>
  <td> <a href="/kubernetes/docs/1.22/charm-easyrsa">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/layer-easyrsa"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 420 </td>
  <td> -- </td>
</tr>
<tr>
  <td> etcd </td>
  <td> Deploy a TLS terminated ETCD Cluster </td>
  <td> <a href="/kubernetes/docs/1.22/charm-etcd">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/layer-etcd"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 634 </td>
  <td> -- </td>
</tr>
<tr>
  <td> flannel </td>
  <td> A charm that provides a robust Software Defined Network </td>
  <td> <a href="/kubernetes/docs/1.22/charm-flannel">docs</a> </td> 
  <td> <a href="https://github.com/coreos/flannel"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 597 </td>
  <td> -- </td>
</tr>
<tr>
  <td> gcp-integrator </td>
  <td> Charm to enable GCP integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-gcp-integrator">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-gcp-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 145 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kata </td>
  <td> Kata untrusted container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.22/charm-kata">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/charm-kata"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 138 </td>
  <td> -- </td>
</tr>
<tr>
  <td> keepalived </td>
  <td> Failover and monitoring daemon for LVS clusters </td>
  <td> <a href="/kubernetes/docs/1.22/charm-keepalived">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-keepalived"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 110 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubeapi-load-balancer </td>
  <td> Nginx Load Balancer </td>
  <td> <a href="/kubernetes/docs/1.22/charm-kubeapi-load-balancer">docs</a> </td> 
  <td> <a href="https://nginx.org/en/"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 844 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-master </td>
  <td> The Kubernetes control plane. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-kubernetes-master">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-master"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 1078 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-worker </td>
  <td> The workload bearing units of a kubernetes cluster </td>
  <td> <a href="/kubernetes/docs/1.22/charm-kubernetes-worker">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-worker"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 816 </td>
  <td> -- </td>
</tr>
<tr>
  <td> openstack-integrator </td>
  <td> Proxy charm to enable OpenStack integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-openstack-integrator">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-openstack-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 182 </td>
  <td> -- </td>
</tr>
<tr>
  <td> tigera-secure-ee </td>
  <td> Tigera Secure Enterprise Edition </td>
  <td> <a href="/kubernetes/docs/1.22/charm-tigera-secure-ee">docs</a> </td> 
  <td> <a href="https://github.com/charmed-kubernetes/layer-tigera-secure-ee"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 230 </td>
  <td> -- </td>
</tr>
<tr>
  <td> vsphere-integrator </td>
  <td> Proxy charm to enable VMware vSphere integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.22/charm-vsphere-integrator">docs</a> </td> 
  <td> <a href="https://github.com/juju-solutions/charm-vsphere-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 123 </td>
  <td> -- </td>
</tr>

 </tbody>
 </table>

## Compatible Charms

These charms are frequently used with Charmed Kubernetes.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>Store page</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> apache2 </td>
  <td> Apache HTTP Server metapackage </td>
  <td> <a href="https://jaas.ai/apache2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> ceph-osd </td>
  <td> Highly scalable distributed storage - Ceph OSD storage </td>
  <td> <a href="https://jaas.ai/ceph-osd">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> elasticsearch </td>
  <td> Open Source, Distributed, RESTful, Search Engine built on Apache Lucene </td>
  <td> <a href="https://jaas.ai/elasticsearch">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> filebeat </td>
  <td> Filebeat is a lightweight, open source shipper for log file data. </td>
  <td> <a href="https://jaas.ai/filebeat">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> grafana </td>
  <td> Graph and Dashboard builder </td>
  <td> <a href="https://jaas.ai/grafana">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> graylog </td>
  <td> Graylog log management system </td>
  <td> <a href="https://jaas.ai/graylog">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> hacluster </td>
  <td> Corosync Cluster Engine - membership, messaging and quorum </td>
  <td> <a href="https://jaas.ai/hacluster">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> mongodb </td>
  <td> An open-source document database, and the leading NoSQL database </td>
  <td> <a href="https://jaas.ai/mongodb">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nagios </td>
  <td> Nagios Core 3 monitoring. </td>
  <td> <a href="https://jaas.ai/nagios">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nfs </td>
  <td> NFS server </td>
  <td> <a href="https://jaas.ai/nfs">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nrpe </td>
  <td> Nagios Remote Plugin Executor Server </td>
  <td> <a href="https://jaas.ai/nrpe">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> prometheus2 </td>
  <td> Monitoring system and timeseries database. v2.0 and later only </td>
  <td> <a href="https://jaas.ai/prometheus2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> telegraf </td>
  <td> The plugin-driven server agent for collecting & reporting metrics. </td>
  <td> <a href="https://jaas.ai/telegraf">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> vault </td>
  <td> a tool for managing secrets </td>
  <td> <a href="https://jaas.ai/vault">docs</a> </td>
  <td>  </td>
</tr>

 </tbody>
 </table>


## Images


These are the container images used by this release:

<!-- GENERATED CONTAINER IMAGES -->

-  cdkbot/microbot-amd64:latest
-  cdkbot/microbot-arm64:latest
-  cdkbot/microbot-s390x:latest
-  cephcsi/cephcsi:v3.3.1
-  coredns/coredns:1.8.3
-  coreos/kube-state-metrics:v1.9.8
-  defaultbackend-amd64:1.5
-  defaultbackend-arm64:1.5
-  defaultbackend-ppc64le:1.5
-  defaultbackend-s390x:1.4
-  dns/k8s-dns-dnsmasq-nanny:1.17.3
-  dns/k8s-dns-kube-dns:1.17.3
-  dns/k8s-dns-sidecar:1.17.3
-  external_storage/nfs-client-provisioner:v3.1.0-k8s1.11
-  k8s-artifacts-prod/ingress-nginx/controller:v1.0.0-beta.3
-  k8scloudprovider/cinder-csi-plugin:v1.22.0
-  k8scloudprovider/k8s-keystone-auth:v1.22.0
-  k8scloudprovider/openstack-cloud-controller-manager:v1.22.0
-  kubernetes-ingress-controller/nginx-ingress-controller-ppc64le:0.20.0
-  kubernetesui/dashboard:v2.2.0
-  kubernetesui/metrics-scraper:v1.0.6
-  metrics-server/metrics-server:v0.5.0
-  nvidia/k8s-device-plugin:v0.9.0
-  pause:3.4.1
-  rancher/rancher:latest
-  sig-storage/csi-attacher:v3.0.2
-  sig-storage/csi-attacher:v3.1.0
-  sig-storage/csi-node-driver-registrar:v2.0.1
-  sig-storage/csi-node-driver-registrar:v2.1.0
-  sig-storage/csi-provisioner:v2.0.4
-  sig-storage/csi-provisioner:v2.2.0
-  sig-storage/csi-resizer:v1.0.1
-  sig-storage/csi-resizer:v1.1.0
-  sig-storage/csi-snapshotter:v4.0.0
-  sig-storage/livenessprobe:v2.2.0
-  sonatype/nexus3:latest

<!-- CONTAINER IMAGES END -->

## Snaps

The following snaps are used by this release of Charmed Kubernetes:

| snap  | confinement | summary | link |
|-------|-------------|---------|------|
|aws-cli| classic | Resource to side-load aws-cli snap in network-restricted deployments. | [store page](https://snapcraft.io/aws-cli) |
|core| strict | core snap | [store page](https://snapcraft.io/core) |
|etcd| classic | Snap package of etcd | [store page](https://snapcraft.io/etcd) |
|cdk-addons| strict | CDK addons snap | [store page](https://snapcraft.io/cdk-addons) |
|kube-apiserver| strict | kube-apiserver snap | [store page](https://snapcraft.io/kube-apiserver) |
|kube-controller-manager| strict | kube-controller-manager snap | [store page](https://snapcraft.io/kube-controller-manager) |
|kube-proxy| classic | kube-proxy snap | [store page](https://snapcraft.io/kube-proxy) |
|kube-scheduler| strict | kube-scheduler snap | [store page](https://snapcraft.io/kube-scheduler) |
|kubectl| classic | kubectl snap | [store page](https://snapcraft.io/kubectl) |
|kubelet| classic | kubelet snap | [store page](https://snapcraft.io/kubelet) |
|openstackclients| classic | Resource to side-load openstackclients snap in network-restricted deployments. | [store page](https://snapcraft.io/openstackclients) |

<!-- LINKS -->
[documentation]: /kubernetes/docs/
[release notes]: /kubernetes/docs/release-notes#1.22
[upgrade notes]: /kubernetes/docs/1.22/upgrade-notes
[bugs]: https://bugs.launchpad.net/charmed-kubernetes
[source]: https://github.com/charmed-kubernetes/bundle
[1.22 milestone]: https://launchpad.net/charmed-kubernetes/+milestone/1.22

