---
wrapper_template: templates/docs/markdown.html
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Keepalived charm '
  description: Failover and monitoring daemon for LVS clusters
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.22/charm-keepalived.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '98'
bundle_release: '1.22'
---

[Keepalived](http://www.keepalived.org/) is software which provides high
availability by assigning two or more nodes a virtual IP (VIP) and monitoring
those nodes, failing over when one goes down.

## Usage

The Keepalived charm is a
[subordinate](https://juju.is/docs/sdk#heading--subordinate-charms).

Allocating a VIP and ensuring that it can route to all of the instances is a
manual process which depends on your infrastructure.  It does require that the
VIP be able to route to each instance, and that the VRRP protocol is allowed on
the network.  While this should be the case on bare metal and MAAS, and can be
made to work on [OpenStack][openstack-vip], it will generally not be possible
on public clouds. Thus, in those cases it is generally better to go with a
cloud-provided load balancer with health checks, such as Octavia or ELB.

[openstack-vip]: https://medium.com/jexia/virtual-ip-with-openstack-neutron-dd9378a48bdf

### Using with Kubernetes ([Charmed Kubernetes](https://charmhub.io/charmed-kubernetes))

Use keepalived with Charmed Kubernetes to ensure kubeapi-load-balancer is not a single
point of failure.

```
# These instructions assume you've deployed Charmed Kubernetes already:
# juju deploy charmed-kubernetes

# deploy the keepalived charm
juju deploy cs:~containers/keepalived

# add new keepalived relations
juju relate keepalived:juju-info kubeapi-load-balancer:juju-info
juju relate keepalived:lb-sink kubeapi-load-balancer:website
juju relate keepalived:loadbalancer kubernetes-master:loadbalancer
juju relate keepalived:website kubernetes-worker:kube-api-endpoint

# remove Charmed Kubernetes relations that are no longer needed
juju remove-relation kubernetes-worker:kube-api-endpoint kubeapi-load-balancer:website
juju remove-relation kubernetes-master:loadbalancer kubeapi-load-balancer:loadbalancer


# NOTE: ensure this relation from Charmed Kubernetes is preserved, so that the
# load-balancer knows about backend endpoints
juju relate kubernetes-master:kube-api-endpoint kubeapi-load-balancer:apiserver || true

# configure keepalived (values are examples, substitute your own)
export VIP_HOSTNAME=test.example.com
juju config keepalived virtual_ip=10.10.74.250
juju config keepalived vip_hostname=$VIP_HOSTNAME

# set extra_sans to update api server ssl cert
juju config kubeapi-load-balancer extra_sans=$VIP_HOSTNAME
juju config kubernetes-master extra_sans=$VIP_HOSTNAME

# if you only have one kubeapi-load-balancer unit, add another one
juju add-unit kubeapi-load-balancer

```
This changes kubelet and kubectl to use the VIP to reach the Kubernetes API server.

### Using with HA Proxy
```
juju deploy cs:~containers/keepalived
juju add-relation haproxy keepalived

```

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-healthcheck_interval"> </a> healthcheck_interval | int | 2 | vrrp_script-based health-check interval, in seconds  |
| <a id="table-network_interface"> </a> network_interface | string |  | Network interface name for the VIP. The default value is the result of running the following command: `route | grep default | head -n 1 | awk {'print $8'}`.  |
| <a id="table-port"> </a> port | int | 443 | A port to pass to clients.  |
| <a id="table-router_id"> </a> router_id | int | 23 | Virtual router identifier - a number between 1 and 255 that's unique within the network segment  |
| <a id="table-vip_hostname"> </a> vip_hostname | string |  | A VIP hostname to pass to clients.  |
| <a id="table-virtual_ip"> </a> virtual_ip | string |  | Virtual IP/netmask that will be moved between instances, e.g.: 10.1.2.3/16  |

---


<!-- CONFIG ENDS -->

<!-- ACTIONS STARTS -->

<!-- ACTIONS ENDS -->