---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Flannel charm '
  description: A charm that provides a robust Software Defined Network
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.21/charm-flannel.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '533'
bundle_release: '1.21'
---

Flannel is a virtual network that gives a subnet to each host for use with
container runtimes.

This charm will deploy flannel as a background service, and configure CNI for
use with flannel, on any principal charm that implements the
[`kubernetes-cni`](https://github.com/juju-solutions/interface-kubernetes-cni) interface.


## Usage

The flannel charm is a
[subordinate](https://juju.is/docs/sdk#heading--subordinate-charms).
This charm will require a principal charm that implements the `kubernetes-cni`
interface in order to properly deploy.

```
juju deploy cs:~containers/flannel
juju deploy cs:~containers/etcd
juju deploy cs:~containers/kubernetes-master
juju deploy cs:~containers/kubernetes-worker
juju add-relation flannel etcd
juju add-relation flannel kubernetes-master
juju add-relation flannel kubernetes-worker
```

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-cidr"> </a> cidr | string | 10.1.0.0/16 | Network CIDR to assign to Flannel  |
| <a id="table-iface"> </a> iface | string |  | The interface to bind flannel overlay networking. The default value is the interface bound to the cni endpoint.  |
| <a id="table-nagios_context"> </a> nagios_context | string | juju | [See notes](#nagios_context-description)  |
| <a id="table-nagios_servicegroups"> </a> nagios_servicegroups | string |  | A comma-separated list of nagios servicegroups. If left empty, the nagios_context will be used as the servicegroup  |

---

### nagios_context


<a id="nagios_context-description"> </a>
**Description:**

Used by the nrpe subordinate charms.
A string that will be prepended to instance name to set the host name
in nagios. So for instance the hostname would be something like:

```
    juju-myservice-0
```

If you're running multiple environments with the same services in them
this allows you to differentiate between them.

[Back to table](#table-nagios_context)



<!-- CONFIG ENDS -->


## Known Limitations

This subordinate does not support being co-located with other deployments of
the flannel subordinate (to gain 2 vlans on a single application). If you
require this support please file a bug.

This subordinate also leverages juju-resources, so it is currently only available
on juju 2.0+ controllers.


## Further information

-   [Flannel Homepage](https://github.com/coreos/flannel)